(*
% File     : MGT053+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : The dissimilarity relation is symmetric
% Version  : [Han98] axioms.
% English  : 
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 7 [Han98]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.17 v2.7.0, 0.00 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    8 (   0 unit)
%            Number of atoms       :   22 (   3 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   16 (   2 ~  ;   4  |;   3  &)
%                                         (   6 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   19 (   0 singleton;  19 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable EqCongruence_is_aligned : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> is_aligned_ x1 x2 -> is_aligned_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_dissimilar : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> dissimilar_ x1 x2 x3 -> dissimilar_ y1 y2 y3 .


Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_2_7 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).

Set Firstorder Depth 10.

Theorem lemma_7_8 : (forall X T1 T2 : Universe, (dissimilar_ X T1 T2 <-> dissimilar_ X T2 T1)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
