(*
% File     : MGT051+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for constant then increasing hazard of mortality
% Version  : [Han98] axioms.
% English  : An endowed organization's hazard of mortality remains constant 
%            during the period of immunity and increases monotonically with 
%            age once immunity ends.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 4 [Han98]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.67 v2.6.0, 0.50 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   16 (   0 unit)
%            Number of atoms       :   73 (  15 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   62 (   5 ~  ;   4  |;  29  &)
%                                         (   4 <=>;  20 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    8 (   1 constant; 0-2 arity)
%            Number of variables   :   44 (   0 singleton;  44 !;   0 ?)
%            Maximal term depth    :    2 (   2 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable EqCongruence_has_immunity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> has_immunity_ x1 x2 -> has_immunity_ y1 y2 .
Variable has_endowment_ : Universe -> Prop.
Variable EqCongruence_has_endowment : forall x1 y1 : Universe, x1 = y1 -> has_endowment_ x1 -> has_endowment_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .

Variable stock_of_knowledge_ : Universe -> Universe -> Universe.
Variable EqCongruence_stock_of_knowledge : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> stock_of_knowledge_ x1 x2 = stock_of_knowledge_ y1 y2 .
Variable position_ : Universe -> Universe -> Universe.
Variable EqCongruence_position : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> position_ x1 x2 = position_ y1 y2 .
Variable internal_friction_ : Universe -> Universe -> Universe.
Variable EqCongruence_internal_friction : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> internal_friction_ x1 x2 = internal_friction_ y1 y2 .
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable EqCongruence_hazard_of_mortality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hazard_of_mortality_ x1 x2 = hazard_of_mortality_ y1 y2 .
Variable external_ties_ : Universe -> Universe -> Universe.
Variable EqCongruence_external_ties : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> external_ties_ x1 x2 = external_ties_ y1 y2 .
Variable eta_ : Universe.
Variable capability_ : Universe -> Universe -> Universe.
Variable EqCongruence_capability : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> capability_ x1 x2 = capability_ y1 y2 .
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable assumption_2_8 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ has_immunity_ X T)) -> (hazard_of_mortality_ X T0) = (hazard_of_mortality_ X T))).
Variable assumption_3_9 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Variable assumption_4_10 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ ~(has_immunity_ X T))) -> (((greater_ (capability_ X T) (capability_ X T0) /\ greater_or_equal_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((greater_or_equal_ (capability_ X T) (capability_ X T0) /\ greater_ (position_ X T) (position_ X T0)) -> smaller_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0)) /\ (((capability_ X T) = (capability_ X T0) /\ (position_ X T) = (position_ X T0)) -> (hazard_of_mortality_ X T) = (hazard_of_mortality_ X T0)))))).
Variable assumption_5_11 : (forall X T0 T : Universe, (organization_ X -> (((greater_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ smaller_or_equal_ (internal_friction_ X T) (internal_friction_ X T0)) -> greater_ (capability_ X T) (capability_ X T0)) /\ (((smaller_or_equal_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ greater_ (internal_friction_ X T) (internal_friction_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0)) /\ (((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (internal_friction_ X T) = (internal_friction_ X T0)) -> (capability_ X T) = (capability_ X T0)))))).
Variable assumption_6_12 : (forall X T0 T : Universe, (organization_ X -> ((greater_ (external_ties_ X T) (external_ties_ X T0) -> greater_ (position_ X T) (position_ X T0)) /\ ((external_ties_ X T) = (external_ties_ X T0) -> (position_ X T) = (position_ X T0))))).
Variable assumption_10_13 : (forall X T0 T : Universe, (organization_ X -> (stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0))).
Variable assumption_11_14 : (forall X T0 T : Universe, (organization_ X -> (external_ties_ X T) = (external_ties_ X T0))).
Variable assumption_12_15 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> greater_ (internal_friction_ X T) (internal_friction_ X T0))).

Set Firstorder Depth 10.

Theorem theorem_4_16 : (forall X T0 T1 T2 T3 : Universe, ((organization_ X /\ (has_endowment_ X /\ (smaller_or_equal_ (age_ X T0) (age_ X T1) /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) eta_ /\ greater_ (age_ X T3) (age_ X T2)))))) -> (greater_ (hazard_of_mortality_ X T3) (hazard_of_mortality_ X T2) /\ (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
