(*
% File     : MGT049+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Structural position does not vary with its age
% Version  : [Han98] axioms.
% English  : An organization's structural position does not vary with its age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 6 [Han98]
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   26 (   7 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   18 (   1 ~  ;   4  |;   4  &)
%                                         (   3 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .

Variable position_ : Universe -> Universe -> Universe.
Variable EqCongruence_position : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> position_ x1 x2 = position_ y1 y2 .
Variable external_ties_ : Universe -> Universe -> Universe.
Variable EqCongruence_external_ties : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> external_ties_ x1 x2 = external_ties_ y1 y2 .
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_6_7 : (forall X T0 T : Universe, (organization_ X -> ((greater_ (external_ties_ X T) (external_ties_ X T0) -> greater_ (position_ X T) (position_ X T0)) /\ ((external_ties_ X T) = (external_ties_ X T0) -> (position_ X T) = (position_ X T0))))).
Variable assumption_11_8 : (forall X T0 T : Universe, (organization_ X -> (external_ties_ X T) = (external_ties_ X T0))).

Set Firstorder Depth 10.

Theorem lemma_6_9 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> (position_ X T) = (position_ X T0))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
