(*
% File     : MGT048+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Capability decreases monotonically with its age
% Version  : [Han98] axioms.
% English  : An organization's capability decreases monotonically with its age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 5 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.5.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   10 (   0 unit)
%            Number of atoms       :   34 (   7 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   25 (   1 ~  ;   4  |;   9  &)
%                                         (   3 <=>;   8 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   0 constant; 2-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .

Variable stock_of_knowledge_ : Universe -> Universe -> Universe.
Variable EqCongruence_stock_of_knowledge : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> stock_of_knowledge_ x1 x2 = stock_of_knowledge_ y1 y2 .
Variable internal_friction_ : Universe -> Universe -> Universe.
Variable EqCongruence_internal_friction : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> internal_friction_ x1 x2 = internal_friction_ y1 y2 .
Variable capability_ : Universe -> Universe -> Universe.
Variable EqCongruence_capability : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> capability_ x1 x2 = capability_ y1 y2 .
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_5_7 : (forall X T0 T : Universe, (organization_ X -> (((greater_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ smaller_or_equal_ (internal_friction_ X T) (internal_friction_ X T0)) -> greater_ (capability_ X T) (capability_ X T0)) /\ (((smaller_or_equal_ (stock_of_knowledge_ X T) (stock_of_knowledge_ X T0) /\ greater_ (internal_friction_ X T) (internal_friction_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0)) /\ (((stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0) /\ (internal_friction_ X T) = (internal_friction_ X T0)) -> (capability_ X T) = (capability_ X T0)))))).
Variable assumption_10_8 : (forall X T0 T : Universe, (organization_ X -> (stock_of_knowledge_ X T) = (stock_of_knowledge_ X T0))).
Variable assumption_12_9 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> greater_ (internal_friction_ X T) (internal_friction_ X T0))).

Set Firstorder Depth 10.

Theorem lemma_5_10 : (forall X T0 T : Universe, ((organization_ X /\ greater_ (age_ X T) (age_ X T0)) -> smaller_ (capability_ X T) (capability_ X T0))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
