(*
% File     : MGT041+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : There are non-FM and non-EP organisations
% Version  : [PM93] axioms.
% English  : There are non-first mover and non-efficient producers
%            organisations. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [PM93]
% Names    : Theorem 10 [PM93]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   17 (   0 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :   16 (   4 ~  ;   0  |;  10  &)
%                                         (   0 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-3 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :   10 (   0 singleton;   6 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable organisation_at_time_ : Universe -> Universe -> Prop.
Variable number_of_routines_ : Universe -> Universe -> Universe -> Prop.
Variable has_elaborated_routines_ : Universe -> Universe -> Prop.
Variable founding_time_ : Universe -> Universe -> Prop.
Variable first_mover_ : Universe -> Prop.
Variable efficient_producer_ : Universe -> Prop.

Variable low_ : Universe.
Variable high_ : Universe.

Variable mp_not_high_and_low_1 : (forall X T : Universe, ~((number_of_routines_ X T low_ /\ number_of_routines_ X T high_))).
Variable a14_2 : (forall X T : Universe, ((organisation_at_time_ X T /\ (efficient_producer_ X /\ founding_time_ X T)) -> has_elaborated_routines_ X T)).
Variable a15_3 : (forall X T : Universe, ((organisation_at_time_ X T /\ (first_mover_ X /\ founding_time_ X T)) -> number_of_routines_ X T low_)).
Variable a16_4 : (exists X T : Universe, (organisation_at_time_ X T /\ (founding_time_ X T /\ (number_of_routines_ X T high_ /\ ~(has_elaborated_routines_ X T))))).

Set Firstorder Depth 10.

Theorem prove_t10_5 : (exists X T : Universe, (organisation_at_time_ X T /\ (~(first_mover_ X) /\ ~(efficient_producer_ X)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
