(*
% File     : MGT039+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favours EPs above Fms if change is slow
% Version  : [PM93] axioms.
% English  : Selection favors efficient producers above first movers if
%            environmental change is slow. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [PM93]
% Names    : Theorem 8 [PM93]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.50 v2.6.0, 0.57 v2.5.0, 0.62 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   19 (   2 unit)
%            Number of atoms       :   71 (   3 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   54 (   2 ~  ;   1  |;  31  &)
%                                         (   1 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-4 arity)
%            Number of functors    :    9 (   3 constant; 0-2 arity)
%            Number of variables   :   38 (   0 singleton;  37 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulation : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> subpopulation_ x1 x2 x3 -> subpopulation_ y1 y2 y3 .
Variable slow_change_ : Universe -> Prop.
Variable EqCongruence_slow_change : forall x1 y1 : Universe, x1 = y1 -> slow_change_ x1 -> slow_change_ y1 .
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_selection_favors : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> selection_favors_ x1 x2 x3 -> selection_favors_ y1 y2 y3 .
Variable propagation_strategy_ : Universe -> Prop.
Variable EqCongruence_propagation_strategy : forall x1 y1 : Universe, x1 = y1 -> propagation_strategy_ x1 -> propagation_strategy_ y1 .
Variable observational_period_ : Universe -> Prop.
Variable EqCongruence_observational_period : forall x1 y1 : Universe, x1 = y1 -> observational_period_ x1 -> observational_period_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .

Variable zero_ : Universe.
Variable start_time_ : Universe -> Universe.
Variable EqCongruence_start_time : forall x1 y1 : Universe, x1 = y1 -> start_time_ x1 = start_time_ y1 .
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable end_time_ : Universe -> Universe.
Variable EqCongruence_end_time : forall x1 y1 : Universe, x1 = y1 -> end_time_ x1 = end_time_ y1 .
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.
Variable EqCongruence_critical_point : forall x1 y1 : Universe, x1 = y1 -> critical_point_ x1 = critical_point_ y1 .
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable EqCongruence_cardinality_at_time : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cardinality_at_time_ x1 x2 = cardinality_at_time_ y1 y2 .
Variable appear_ : Universe -> Universe -> Universe.
Variable EqCongruence_appear : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> appear_ x1 x2 = appear_ y1 y2 .

Variable mp1_high_growth_rates_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulations_ S1 S2 E T /\ greater_ (growth_rate_ S2 T) (growth_rate_ S1 T))) -> selection_favors_ S2 S1 T)).
Variable mp2_favour_members_2 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulation_ S1 E T /\ (subpopulation_ S2 E T /\ (greater_ (cardinality_at_time_ S1 T) zero_ /\ (cardinality_at_time_ S2 T) = zero_)))) -> selection_favors_ S1 S2 T)).
Variable mp3_favoured_trategy_3 : (forall P : Universe, ((observational_period_ P /\ (propagation_strategy_ first_movers_ /\ (propagation_strategy_ efficient_producers_ /\ (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> selection_favors_ efficient_producers_ first_movers_ (end_time_ E)))))) -> selection_favors_ efficient_producers_ first_movers_ P)).
Variable mp4_critical_point_4 : (forall P : Universe, ((observational_period_ P /\ slow_change_ P) -> (forall E : Universe, ((environment_ E /\ in_environment_ P E) -> (exists T : Universe, (in_environment_ E T /\ greater_ T (critical_point_ E))))))).
Variable mp_organizational_sets1_5 : propagation_strategy_ first_movers_.
Variable mp_organizational_sets2_6 : propagation_strategy_ efficient_producers_.
Variable mp_time_in_environment_7 : (forall E T : Universe, ((environment_ E /\ (greater_or_equal_ T (start_time_ E) /\ greater_or_equal_ (end_time_ E) T)) -> in_environment_ E T)).
Variable mp_environment_end_point_8 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> greater_or_equal_ (end_time_ E) T)).
Variable mp_contains_FM_and_EP_9 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))) -> subpopulations_ first_movers_ efficient_producers_ E T)).
Variable mp_first_movers_exist_10 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> greater_or_equal_ (cardinality_at_time_ first_movers_ T) zero_)).
Variable mp_subpopulations_11 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_critical_point_after_EP_12 : (forall E : Universe, (environment_ E -> greater_or_equal_ (critical_point_ E) (appear_ efficient_producers_ E))).
Variable mp_time_of_critical_point_13 : (forall E : Universe, (environment_ E -> greater_or_equal_ (critical_point_ E) (start_time_ E))).
Variable mp_greater_transitivity_14 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_beginning_and_ending_15 : (forall E T : Universe, ((environment_ E /\ (greater_ T (start_time_ E) /\ ~(greater_ T (end_time_ E)))) -> greater_or_equal_ (end_time_ E) T)).
Variable mp_greater_or_equal_16 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable d1_17 : (forall E Tc : Universe, ((environment_ E /\ Tc = (critical_point_ E)) -> (~(greater_ (growth_rate_ efficient_producers_ Tc) (growth_rate_ first_movers_ Tc)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T Tc) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))).
Variable t6_18 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ efficient_producers_ E))) -> greater_ (cardinality_at_time_ efficient_producers_ T) zero_)).

Set Firstorder Depth 10.

Theorem prove_t8_19 : (forall P : Universe, ((observational_period_ P /\ slow_change_ P) -> selection_favors_ efficient_producers_ first_movers_ P)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
