(*
% File     : MGT036+3 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : First movers never outcompete efficient producers. 
% Version  : [PM93] axioms.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
% Source   : [PM93]
% Names    : THEOREM 5* [PM93]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   15 (   0 equality)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   11 (   0 ~  ;   0  |;   8  &)
%                                         (   1 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-4 arity)
%            Number of functors    :    4 (   3 constant; 0-2 arity)
%            Number of variables   :   12 (   0 singleton;   8 !;   4 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable outcompetes_ : Universe -> Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable zero_ : Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.

Variable mp_symmetry_of_subpopulations_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ subpopulations_ S1 S2 E T) -> subpopulations_ S2 S1 E T)).
Variable d2_2 : (forall E S1 S2 T : Universe, ((environment_ E /\ subpopulations_ S1 S2 E T) -> ((greater_or_equal_ (growth_rate_ S2 T) zero_ /\ greater_ zero_ (growth_rate_ S1 T)) <-> outcompetes_ S2 S1 T))).
Variable a13_star_3 : (exists E T : Universe, (environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ (greater_or_equal_ (growth_rate_ first_movers_ T) zero_ /\ greater_ zero_ (growth_rate_ efficient_producers_ T))))).

Set Firstorder Depth 10.

Theorem prove_t5_star_4 : (exists E T : Universe, (environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ outcompetes_ first_movers_ efficient_producers_ T))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
