(*
% File     : MGT035+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : EPs outcompete FMs in stable environments
% Version  : [PM93] axioms.
% English  : Efficient producers outcompete first movers past a certain
%            time in stable environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : THEOREM 4 [PM93]
%          : T4 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   20 (   0 unit)
%            Number of atoms       :   95 (  10 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   80 (   5 ~  ;   7  |;  39  &)
%                                         (   2 <=>;  27 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-4 arity)
%            Number of functors    :    9 (   3 constant; 0-2 arity)
%            Number of variables   :   50 (   0 singleton;  47 !;   3 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulation : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> subpopulation_ x1 x2 x3 -> subpopulation_ y1 y2 y3 .
Variable stable_ : Universe -> Prop.
Variable EqCongruence_stable : forall x1 y1 : Universe, x1 = y1 -> stable_ x1 -> stable_ y1 .
Variable outcompetes_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_outcompetes : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> outcompetes_ x1 x2 x3 -> outcompetes_ y1 y2 y3 .
Variable increases_ : Universe -> Prop.
Variable EqCongruence_increases : forall x1 y1 : Universe, x1 = y1 -> increases_ x1 -> increases_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .
Variable decreases_ : Universe -> Prop.
Variable EqCongruence_decreases : forall x1 y1 : Universe, x1 = y1 -> decreases_ x1 -> decreases_ y1 .
Variable constant_ : Universe -> Prop.
Variable EqCongruence_constant : forall x1 y1 : Universe, x1 = y1 -> constant_ x1 -> constant_ y1 .

Variable zero_ : Universe.
Variable sum_ : Universe -> Universe -> Universe.
Variable EqCongruence_sum : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> sum_ x1 x2 = sum_ y1 y2 .
Variable resources_ : Universe -> Universe -> Universe.
Variable EqCongruence_resources : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> resources_ x1 x2 = resources_ y1 y2 .
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable EqCongruence_number_of_organizations : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> number_of_organizations_ x1 x2 = number_of_organizations_ y1 y2 .
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable EqCongruence_equilibrium : forall x1 y1 : Universe, x1 = y1 -> equilibrium_ x1 = equilibrium_ y1 .
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable EqCongruence_cardinality_at_time : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cardinality_at_time_ x1 x2 = cardinality_at_time_ y1 y2 .

Variable mp_time_point_in_environment_1 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_environment_not_empty_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (number_of_organizations_ E T) zero_)).
Variable mp_only_members_3 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ (greater_ (cardinality_at_time_ X T) zero_ -> (X = efficient_producers_ \/ X = first_movers_)))) -> (number_of_organizations_ E T) = (sum_ (cardinality_at_time_ first_movers_ T) (cardinality_at_time_ efficient_producers_ T)))).
Variable mp_FM_and_EP_organisational_4 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_abc_sum_increase_5 : (forall A B C : Universe, ((A = (sum_ B C) /\ constant_ A) -> ((constant_ B /\ constant_ C) \/ ((increases_ B /\ decreases_ C) \/ (decreases_ B /\ increases_ C))))).
Variable mp_growth_rate_6 : (forall X E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_))) -> ((constant_ (cardinality_at_time_ X T) -> (growth_rate_ X T) = zero_) /\ ((increases_ (cardinality_at_time_ X T) -> greater_ (growth_rate_ X T) zero_) /\ (decreases_ (cardinality_at_time_ X T) -> greater_ zero_ (growth_rate_ X T)))))).
Variable mp_positive_number_of_organizations_7 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))).
Variable mp6_1_8 : (forall X Y : Universe, ~((greater_ X Y /\ X = Y))).
Variable mp6_2_9 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable mp_greater_transitivity_10 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_times_in_environment_11 : (forall E T1 T2 : Universe, ((in_environment_ E T1 /\ in_environment_ E T2) -> (greater_ T2 T1 \/ (T2 = T1 \/ greater_ T1 T2)))).
Variable mp_greater_or_equal_12 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable mp_equilibrium_13 : (forall E T : Universe, ((environment_ E /\ greater_or_equal_ T (equilibrium_ E)) -> ~(greater_ (equilibrium_ E) T))).
Variable d2_14 : (forall E S1 S2 T : Universe, ((environment_ E /\ subpopulations_ S1 S2 E T) -> ((greater_or_equal_ (growth_rate_ S2 T) zero_ /\ greater_ zero_ (growth_rate_ S1 T)) <-> outcompetes_ S2 S1 T))).
Variable a4_15 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (number_of_organizations_ E T) zero_)) -> ((greater_ (equilibrium_ E) T -> decreases_ (resources_ E T)) /\ (~(greater_ (equilibrium_ E) T) -> constant_ (resources_ E T))))).
Variable a5_16 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists T : Universe, (in_environment_ E T /\ greater_or_equal_ T (equilibrium_ E))))).
Variable a7_17 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> ((decreases_ (resources_ E T) -> ~(decreases_ (number_of_organizations_ E T))) /\ (constant_ (resources_ E T) -> constant_ (number_of_organizations_ E T))))).
Variable a11_18 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).
Variable l1_19 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).

Set Firstorder Depth 10.

Theorem prove_t4_20 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> outcompetes_ efficient_producers_ first_movers_ T)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
