(*
% File     : MGT034+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favors FMs above EPs until critical point reached
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : Selection favors first movers above efficient producers past 
%            the appearance of efficient producers until the critical
%            point is reached. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.33 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   19 (   0 unit)
%            Number of atoms       :   70 (   2 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   55 (   4 ~  ;   1  |;  29  &)
%                                         (   3 <=>;  18 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-4 arity)
%            Number of functors    :   10 (   3 constant; 0-2 arity)
%            Number of variables   :   39 (   0 singleton;  39 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_selection_favors : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> selection_favors_ x1 x2 x3 -> selection_favors_ y1 y2 y3 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .
Variable decreases_ : Universe -> Prop.
Variable EqCongruence_decreases : forall x1 y1 : Universe, x1 = y1 -> decreases_ x1 -> decreases_ y1 .

Variable zero_ : Universe.
Variable start_time_ : Universe -> Universe.
Variable EqCongruence_start_time : forall x1 y1 : Universe, x1 = y1 -> start_time_ x1 = start_time_ y1 .
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable founding_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_founding_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> founding_rate_ x1 x2 = founding_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_disbanding_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disbanding_rate_ x1 x2 = disbanding_rate_ y1 y2 .
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .
Variable critical_point_ : Universe -> Universe.
Variable EqCongruence_critical_point : forall x1 y1 : Universe, x1 = y1 -> critical_point_ x1 = critical_point_ y1 .
Variable appear_ : Universe -> Universe -> Universe.
Variable EqCongruence_appear : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> appear_ x1 x2 = appear_ y1 y2 .

Variable mp1_high_growth_rates_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulations_ S1 S2 E T /\ greater_ (growth_rate_ S2 T) (growth_rate_ S1 T))) -> selection_favors_ S2 S1 T)).
Variable l3_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))).
Variable mp_critical_point_means_FM_and_EP_3 : (forall E : Universe, ((environment_ E /\ in_environment_ E (critical_point_ E)) -> subpopulations_ first_movers_ efficient_producers_ E (critical_point_ E))).
Variable mp_FM_and_EP_when_EP_appears_4 : (forall E : Universe, ((environment_ E /\ in_environment_ E (appear_ efficient_producers_ E)) -> subpopulations_ first_movers_ efficient_producers_ E (appear_ efficient_producers_ E))).
Variable mp_decreasing_function_5 : (forall E T To : Universe, ((environment_ E /\ (in_environment_ E To /\ (greater_or_equal_ (difference_ (growth_rate_ first_movers_ To) (growth_rate_ efficient_producers_ To)) zero_ /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ greater_ To T)))) -> (decreases_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T)) -> greater_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T)) zero_))).
Variable mp_difference_between_founding_rates_6 : (forall T : Universe, ((decreases_ (difference_ (founding_rate_ first_movers_ T) (founding_rate_ efficient_producers_ T)) /\ ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T)))) -> decreases_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T)))).
Variable mp_negative_growth_rate_difference_7 : (forall T : Universe, (greater_ zero_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T)) <-> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))).
Variable mp_positive_growth_rate_difference_8 : (forall T : Universe, (greater_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T)) zero_ <-> greater_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T))).
Variable mp_durations_are_time_intervals_9 : (forall E T1 T2 T : Universe, ((environment_ E /\ (in_environment_ E T1 /\ (in_environment_ E T2 /\ (greater_or_equal_ T2 T /\ greater_or_equal_ T T1)))) -> in_environment_ E T)).
Variable mp_opening_time_in_duration_10 : (forall E : Universe, (environment_ E -> in_environment_ E (start_time_ E))).
Variable mp_no_FM_before_opening_11 : (forall E : Universe, (environment_ E -> greater_or_equal_ (appear_ first_movers_ E) (start_time_ E))).
Variable mp_symmetry_of_FM_and_EP_12 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> subpopulations_ efficient_producers_ first_movers_ E T)).
Variable mp_FM_and_EP_members_EP_appeared_13 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_or_equal_ T (appear_ efficient_producers_ E))).
Variable mp_greater_or_equal_14 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable mp_relationship_of_growth_rates_15 : (forall E T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ ~(greater_ zero_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T))))) -> greater_or_equal_ (difference_ (growth_rate_ first_movers_ T) (growth_rate_ efficient_producers_ T)) zero_)).
Variable a10_16 : (forall E T1 T2 T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T1 /\ (subpopulations_ first_movers_ efficient_producers_ E T2 /\ (greater_or_equal_ T T1 /\ greater_or_equal_ T2 T)))) -> subpopulations_ first_movers_ efficient_producers_ E T)).
Variable d1_17 : (forall E Tc : Universe, ((environment_ E /\ Tc = (critical_point_ E)) -> (~(greater_ (growth_rate_ efficient_producers_ Tc) (growth_rate_ first_movers_ Tc)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T Tc) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))).
Variable a11_18 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> decreases_ (difference_ (founding_rate_ first_movers_ T) (founding_rate_ efficient_producers_ T)))).

Set Firstorder Depth 10.

Theorem prove_t3_19 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E (critical_point_ E) /\ (greater_or_equal_ T (appear_ efficient_producers_ E) /\ greater_ (critical_point_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
