(*
% File     : MGT033+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favors FMs above EPs until EPs appear
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : Selection favors first movers above efficient producers 
%            until the appearance of efficient producers. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   14 (   0 unit)
%            Number of atoms       :   53 (   6 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   40 (   1 ~  ;   1  |;  24  &)
%                                         (   0 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-3 arity)
%            Number of functors    :    9 (   5 constant; 0-2 arity)
%            Number of variables   :   31 (   0 singleton;  30 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulation : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> subpopulation_ x1 x2 x3 -> subpopulation_ y1 y2 y3 .
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_selection_favors : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> selection_favors_ x1 x2 x3 -> selection_favors_ y1 y2 y3 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .

Variable zero_ : Universe.
Variable t_ : Universe.
Variable start_time_ : Universe -> Universe.
Variable EqCongruence_start_time : forall x1 y1 : Universe, x1 = y1 -> start_time_ x1 = start_time_ y1 .
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable EqCongruence_number_of_organizations : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> number_of_organizations_ x1 x2 = number_of_organizations_ y1 y2 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable EqCongruence_cardinality_at_time : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cardinality_at_time_ x1 x2 = cardinality_at_time_ y1 y2 .
Variable appear_ : Universe -> Universe -> Universe.
Variable EqCongruence_appear : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> appear_ x1 x2 = appear_ y1 y2 .
Variable an_organisation_ : Universe.

Variable mp2_favour_members_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulation_ S1 E T /\ (subpopulation_ S2 E T /\ (greater_ (cardinality_at_time_ S1 T) zero_ /\ (cardinality_at_time_ S2 T) = zero_)))) -> selection_favors_ S1 S2 T)).
Variable mp_not_present_before_appearance_2 : (forall E X T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (appear_ X E) T)) -> (cardinality_at_time_ X T) = zero_)).
Variable mp_positive_sum_means_members_3 : (forall E T : Universe, ((environment_ E /\ greater_ (number_of_organizations_ E T) zero_) -> (exists X : Universe, (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)))).
Variable mp_zero_is_not_positive_4 : (forall X T : Universe, ((cardinality_at_time_ X t_) = zero_ -> ~(greater_ (cardinality_at_time_ X T) zero_))).
Variable mp_positive_and_sustains_5 : (forall E T : Universe, ((environment_ E /\ greater_ (number_of_organizations_ E T) zero_) -> in_environment_ E T)).
Variable mp_durations_are_time_intervals_6 : (forall E T1 T2 T : Universe, ((environment_ E /\ (in_environment_ E T1 /\ (in_environment_ E T2 /\ (greater_or_equal_ T2 T /\ greater_or_equal_ T T1)))) -> in_environment_ E T)).
Variable mp_opening_time_in_duration_7 : (forall E : Universe, (environment_ E -> in_environment_ E (start_time_ E))).
Variable mp_no_FM_before_opening_8 : (forall E : Universe, (environment_ E -> greater_or_equal_ (appear_ first_movers_ E) (start_time_ E))).
Variable mp_subpopulations_9 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_FM_means_organisations_10 : (forall E : Universe, ((environment_ E /\ in_environment_ E (appear_ first_movers_ E)) -> in_environment_ E (appear_ an_organisation_ E))).
Variable a1_11 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_or_equal_ T (appear_ an_organisation_ E))) -> greater_ (number_of_organizations_ E T) zero_)).
Variable a9_12 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).
Variable l13_13 : (forall E : Universe, ((environment_ E /\ in_environment_ E (appear_ an_organisation_ E)) -> (appear_ an_organisation_ E) = (appear_ first_movers_ E))).

Set Firstorder Depth 10.

Theorem prove_t2_14 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (greater_or_equal_ T (appear_ first_movers_ E) /\ greater_ (appear_ efficient_producers_ E) T))) -> selection_favors_ first_movers_ efficient_producers_ T)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
