(*
% File     : MGT032+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Selection favours EPs above FMs
% Version  : [PM93] axioms.
% English  : In stable environments, selection favors efficient producers 
%            above first movers past a certain point in time. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [PM93]
% Names    : THEOREM 1 [PM93]
%          : T1 [PB+94]
% Status   : Theorem
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Rating (intuit.) : 0.00 v1.1
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :    8 (   8 average)
%            Number of connectives :   13 (   0 ~  ;   0  |;   8  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-4 arity)
%            Number of functors    :    3 (   2 constant; 0-2 arity)
%            Number of variables   :   10 (   0 singleton;   8 !;   2 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable selection_favors_ : Universe -> Universe -> Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.

Variable mp1_high_growth_rates_1 : (forall E S1 S2 T : Universe, ((environment_ E /\ (subpopulations_ S1 S2 E T /\ greater_ (growth_rate_ S2 T) (growth_rate_ S1 T))) -> selection_favors_ S2 S1 T)).
Variable l1_2 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).

Set Firstorder Depth 10.

Theorem prove_t1_3 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> selection_favors_ efficient_producers_ first_movers_ T)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
