(*
% File     : MGT031+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : First movers appear first in an environment
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   10 (   0 unit)
%            Number of atoms       :   32 (   4 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   24 (   2 ~  ;   2  |;  10  &)
%                                         (   1 <=>;   9 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-3 arity)
%            Number of functors    :    8 (   5 constant; 0-2 arity)
%            Number of variables   :   19 (   0 singleton;  18 !;   1 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulation : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> subpopulation_ x1 x2 x3 -> subpopulation_ y1 y2 y3 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .

Variable zero_ : Universe.
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable EqCongruence_number_of_organizations : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> number_of_organizations_ x1 x2 = number_of_organizations_ y1 y2 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable e_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable EqCongruence_cardinality_at_time : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cardinality_at_time_ x1 x2 = cardinality_at_time_ y1 y2 .
Variable appear_ : Universe -> Universe -> Universe.
Variable EqCongruence_appear : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> appear_ x1 x2 = appear_ y1 y2 .
Variable an_organisation_ : Universe.

Variable mp_positive_number_when_appear_1 : (forall E : Universe, (environment_ E -> greater_ (number_of_organizations_ e_ (appear_ an_organisation_ E)) zero_)).
Variable mp_number_mean_non_empty_2 : (forall E T : Universe, ((environment_ E /\ greater_ (number_of_organizations_ E T) zero_) -> (exists S : Universe, (subpopulation_ S E T /\ greater_ (cardinality_at_time_ S T) zero_)))).
Variable mp_no_EP_before_appearance_3 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (appear_ efficient_producers_ E) T)) -> ~(greater_ (cardinality_at_time_ efficient_producers_ T) zero_))).
Variable mp_no_FM_before_appearance_4 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (appear_ first_movers_ E) T)) -> ~(greater_ (cardinality_at_time_ first_movers_ T) zero_))).
Variable mp_FM_not_precede_first_5 : (forall E : Universe, (environment_ E -> greater_or_equal_ (appear_ first_movers_ E) (appear_ an_organisation_ E))).
Variable mp_greater_transitivity_6 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_greater_or_equal_7 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable a9_8 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).
Variable a13_9 : (forall E : Universe, (environment_ E -> greater_ (appear_ efficient_producers_ e_) (appear_ first_movers_ E))).

Set Firstorder Depth 10.

Theorem prove_l13_10 : (forall E : Universe, ((environment_ E /\ in_environment_ E (appear_ an_organisation_ E)) -> (appear_ an_organisation_ E) = (appear_ first_movers_ E))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
