(*
% File     : MGT030+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Earliest time point when FM growth rate exceeds EP growth rate
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : There is an earliest time point, past which FM's growth
%            rate exceeds EP's growth rate. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   23 (   0 equality)
%            Maximal formula depth :    9 (   9 average)
%            Number of connectives :   22 (   2 ~  ;   0  |;  13  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-4 arity)
%            Number of functors    :    3 (   2 constant; 0-2 arity)
%            Number of variables   :   11 (   0 singleton;   7 !;   4 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.

Variable mp_earliest_time_growth_rate_exceeds_1 : (forall E : Universe, ((environment_ E /\ (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))) -> (exists To : Universe, (in_environment_ E To /\ (~(greater_ (growth_rate_ efficient_producers_ To) (growth_rate_ first_movers_ To)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))))).
Variable l1_2 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).

Set Firstorder Depth 10.

Theorem prove_l12_3 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (~(greater_ (growth_rate_ efficient_producers_ To) (growth_rate_ first_movers_ To)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
