(*
% File     : MGT029+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : EPs have positive and FMs have negative growth rates
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : Efficient producers have positive, while first movers have
%            negative growth rate past a certain point of time in stable
%            environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.45 v3.1.0, 0.44 v2.7.0, 0.50 v2.6.0, 0.57 v2.5.0, 0.62 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   37 (   4 equality)
%            Maximal formula depth :    8 (   7 average)
%            Number of connectives :   30 (   0 ~  ;   5  |;  16  &)
%                                         (   1 <=>;   8 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-4 arity)
%            Number of functors    :    5 (   3 constant; 0-2 arity)
%            Number of variables   :   18 (   0 singleton;  15 !;   3 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable stable_ : Universe -> Prop.
Variable EqCongruence_stable : forall x1 y1 : Universe, x1 = y1 -> stable_ x1 -> stable_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .

Variable zero_ : Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable EqCongruence_equilibrium : forall x1 y1 : Universe, x1 = y1 -> equilibrium_ x1 = equilibrium_ y1 .
Variable efficient_producers_ : Universe.

Variable mp_greater_transitivity_1 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_times_in_environment_2 : (forall E T1 T2 : Universe, ((in_environment_ E T1 /\ in_environment_ E T2) -> (greater_ T2 T1 \/ (T2 = T1 \/ greater_ T1 T2)))).
Variable mp_greater_or_equal_3 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable l6_4 : (forall E T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T (equilibrium_ E))) -> (((growth_rate_ first_movers_ T) = zero_ /\ (growth_rate_ efficient_producers_ T) = zero_) \/ ((greater_ (growth_rate_ first_movers_ T) zero_ /\ greater_ zero_ (growth_rate_ efficient_producers_ T)) \/ (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))).
Variable l1_5 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).
Variable a4_6 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists T : Universe, (in_environment_ E T /\ greater_or_equal_ T (equilibrium_ E))))).

Set Firstorder Depth 10.

Theorem prove_l11_7 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
