(*
% File     : MGT028+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : FMs have a negative growth rate in stable environments
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : First movers have negative growth rate past a certain point
%            of time (also after the appearence of efficient producers) 
%            in stable environments. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   23 (   0 equality)
%            Maximal formula depth :   10 (   9 average)
%            Number of connectives :   20 (   0 ~  ;   0  |;  13  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-4 arity)
%            Number of functors    :    5 (   3 constant; 0-2 arity)
%            Number of variables   :   11 (   0 singleton;   7 !;   4 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable stable_ : Universe -> Prop.
Variable in_environment_ : Universe -> Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable environment_ : Universe -> Prop.

Variable zero_ : Universe.
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable appear_ : Universe -> Universe -> Universe.

Variable mp_first_movers_negative_growth_1 : (forall E : Universe, ((environment_ E /\ (stable_ E /\ (exists T1 : Universe, (in_environment_ E T1 /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T T1) -> greater_ zero_ (growth_rate_ first_movers_ T))))))) -> (exists T2 : Universe, (greater_ T2 (appear_ efficient_producers_ E) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T T2) -> greater_ zero_ (growth_rate_ first_movers_ T))))))).
Variable l11_2 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))))).

Set Firstorder Depth 10.

Theorem prove_l10_3 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (greater_ To (appear_ efficient_producers_ E) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ zero_ (growth_rate_ first_movers_ T))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
