(*
% File     : MGT025+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Constant population means opposite growth rates
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : If one of the two subpopulations has positive growth rate, 
%            then the other subpopulation must have negative growth rate 
%            if the total number of organizations is constant. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.44 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    8 (   0 unit)
%            Number of atoms       :   49 (   9 equality)
%            Maximal formula depth :    9 (   7 average)
%            Number of connectives :   41 (   0 ~  ;   6  |;  23  &)
%                                         (   0 <=>;  12 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-4 arity)
%            Number of functors    :    7 (   3 constant; 0-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable subpopulation_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulation : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> subpopulation_ x1 x2 x3 -> subpopulation_ y1 y2 y3 .
Variable increases_ : Universe -> Prop.
Variable EqCongruence_increases : forall x1 y1 : Universe, x1 = y1 -> increases_ x1 -> increases_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .
Variable decreases_ : Universe -> Prop.
Variable EqCongruence_decreases : forall x1 y1 : Universe, x1 = y1 -> decreases_ x1 -> decreases_ y1 .
Variable constant_ : Universe -> Prop.
Variable EqCongruence_constant : forall x1 y1 : Universe, x1 = y1 -> constant_ x1 -> constant_ y1 .

Variable zero_ : Universe.
Variable sum_ : Universe -> Universe -> Universe.
Variable EqCongruence_sum : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> sum_ x1 x2 = sum_ y1 y2 .
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable EqCongruence_number_of_organizations : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> number_of_organizations_ x1 x2 = number_of_organizations_ y1 y2 .
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable cardinality_at_time_ : Universe -> Universe -> Universe.
Variable EqCongruence_cardinality_at_time : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cardinality_at_time_ x1 x2 = cardinality_at_time_ y1 y2 .

Variable mp_only_members_1 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ (greater_ (cardinality_at_time_ X T) zero_ -> (X = efficient_producers_ \/ X = first_movers_)))) -> (number_of_organizations_ E T) = (sum_ (cardinality_at_time_ first_movers_ T) (cardinality_at_time_ efficient_producers_ T)))).
Variable mp_subpopulations_2 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> (subpopulation_ first_movers_ E T /\ subpopulation_ efficient_producers_ E T))).
Variable mp_abc_sum_increase_3 : (forall A B C : Universe, ((A = (sum_ B C) /\ constant_ A) -> ((constant_ B /\ constant_ C) \/ ((increases_ B /\ decreases_ C) \/ (decreases_ B /\ increases_ C))))).
Variable mp_growth_rate_4 : (forall X E T : Universe, ((environment_ E /\ (in_environment_ E T /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_))) -> ((constant_ (cardinality_at_time_ X T) -> (growth_rate_ X T) = zero_) /\ ((increases_ (cardinality_at_time_ X T) -> greater_ (growth_rate_ X T) zero_) /\ (decreases_ (cardinality_at_time_ X T) -> greater_ zero_ (growth_rate_ X T)))))).
Variable mp_non_zero_producers_5 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> (greater_ (cardinality_at_time_ first_movers_ T) zero_ /\ greater_ (cardinality_at_time_ efficient_producers_ T) zero_))).
Variable mp_time_point_occur_6 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable a9_7 : (forall E X T : Universe, ((environment_ E /\ (subpopulation_ X E T /\ greater_ (cardinality_at_time_ X T) zero_)) -> (X = efficient_producers_ \/ X = first_movers_))).

Set Firstorder Depth 10.

Theorem prove_l7_8 : (forall E T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ constant_ (number_of_organizations_ E T))) -> (((growth_rate_ first_movers_ T) = zero_ /\ (growth_rate_ efficient_producers_ T) = zero_) \/ ((greater_ (growth_rate_ first_movers_ T) zero_ /\ greater_ zero_ (growth_rate_ efficient_producers_ T)) \/ (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
