(*
% File     : MGT024+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Subpopulation growth rates are in equilibria
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : If a subpopulation has positive growth rate, then the other 
%            subpopulation must have negative growth rate in equilibrium. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.00 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   40 (   4 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :   36 (   3 ~  ;   4  |;  18  &)
%                                         (   0 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-4 arity)
%            Number of functors    :    7 (   3 constant; 0-2 arity)
%            Number of variables   :   14 (   0 singleton;  14 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .
Variable decreases_ : Universe -> Prop.
Variable EqCongruence_decreases : forall x1 y1 : Universe, x1 = y1 -> decreases_ x1 -> decreases_ y1 .
Variable constant_ : Universe -> Prop.
Variable EqCongruence_constant : forall x1 y1 : Universe, x1 = y1 -> constant_ x1 -> constant_ y1 .

Variable zero_ : Universe.
Variable resources_ : Universe -> Universe -> Universe.
Variable EqCongruence_resources : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> resources_ x1 x2 = resources_ y1 y2 .
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable EqCongruence_number_of_organizations : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> number_of_organizations_ x1 x2 = number_of_organizations_ y1 y2 .
Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable EqCongruence_equilibrium : forall x1 y1 : Universe, x1 = y1 -> equilibrium_ x1 = equilibrium_ y1 .
Variable efficient_producers_ : Universe.

Variable mp_time_point_occur_1 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_positive_number_of_organizations_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (number_of_organizations_ E T) zero_)).
Variable mp_equilibrium_3 : (forall E T : Universe, ((environment_ E /\ greater_or_equal_ T (equilibrium_ E)) -> ~(greater_ (equilibrium_ E) T))).
Variable a3_4 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (number_of_organizations_ E T) zero_)) -> ((greater_ (equilibrium_ E) T -> decreases_ (resources_ E T)) /\ (~(greater_ (equilibrium_ E) T) -> constant_ (resources_ E T))))).
Variable a6_5 : (forall E T : Universe, ((environment_ E /\ in_environment_ E T) -> ((decreases_ (resources_ E T) -> ~(decreases_ (number_of_organizations_ E T))) /\ (constant_ (resources_ E T) -> constant_ (number_of_organizations_ E T))))).
Variable l7_6 : (forall E T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ constant_ (number_of_organizations_ E T))) -> (((growth_rate_ first_movers_ T) = zero_ /\ (growth_rate_ efficient_producers_ T) = zero_) \/ ((greater_ (growth_rate_ first_movers_ T) zero_ /\ greater_ zero_ (growth_rate_ efficient_producers_ T)) \/ (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))).

Set Firstorder Depth 10.

Theorem prove_l6_7 : (forall E T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T (equilibrium_ E))) -> (((growth_rate_ first_movers_ T) = zero_ /\ (growth_rate_ efficient_producers_ T) = zero_) \/ ((greater_ (growth_rate_ first_movers_ T) zero_ /\ greater_ zero_ (growth_rate_ efficient_producers_ T)) \/ (greater_ (growth_rate_ efficient_producers_ T) zero_ /\ greater_ zero_ (growth_rate_ first_movers_ T)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
