(*
% File     : MGT023+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Stable environments have a critical point.
% Version  : [PB+94] axioms : Reduced & Augmented > Complete.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.29 v2.5.0, 0.25 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   17 (   1 equality)
%            Maximal formula depth :   10 (   8 average)
%            Number of connectives :   16 (   2 ~  ;   0  |;   9  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-4 arity)
%            Number of functors    :    4 (   2 constant; 0-2 arity)
%            Number of variables   :    7 (   0 singleton;   6 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable stable_ : Universe -> Prop.
Variable EqCongruence_stable : forall x1 y1 : Universe, x1 = y1 -> stable_ x1 -> stable_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .

Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable critical_point_ : Universe -> Universe.
Variable EqCongruence_critical_point : forall x1 y1 : Universe, x1 = y1 -> critical_point_ x1 = critical_point_ y1 .

Variable d1_1 : (forall E To : Universe, ((environment_ E /\ (~(greater_ (growth_rate_ efficient_producers_ To) (growth_rate_ first_movers_ To)) /\ (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))) -> To = (critical_point_ E))).
Variable l12_2 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (~(greater_ (growth_rate_ efficient_producers_ To) (growth_rate_ first_movers_ To)) /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T)))))))).

Set Firstorder Depth 10.

Theorem prove_l5_3 : (forall E : Universe, ((environment_ E /\ stable_ E) -> in_environment_ E (critical_point_ E))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
