(*
% File     : MGT021+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Difference between disbanding rates does not decrease
% Version  : [PB+94] axioms.
% English  : The difference between the disbanding rates of first movers 
%            and efficient producers does not decrease with time. 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : LEMMA 3 [PM93]
%          : L3 [PB+94]
% Status   : Theorem
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Rating (intuit.) : 0.75 v1.1
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   27 (   1 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   24 (   4 ~  ;   1  |;   8  &)
%                                         (   0 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-4 arity)
%            Number of functors    :    8 (   3 constant; 0-2 arity)
%            Number of variables   :   13 (   0 singleton;  13 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : Same as version with [PM93] axioms.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable increases_ : Universe -> Prop.
Variable EqCongruence_increases : forall x1 y1 : Universe, x1 = y1 -> increases_ x1 -> increases_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .
Variable decreases_ : Universe -> Prop.
Variable EqCongruence_decreases : forall x1 y1 : Universe, x1 = y1 -> decreases_ x1 -> decreases_ y1 .
Variable constant_ : Universe -> Prop.
Variable EqCongruence_constant : forall x1 y1 : Universe, x1 = y1 -> constant_ x1 -> constant_ y1 .

Variable zero_ : Universe.
Variable resources_ : Universe -> Universe -> Universe.
Variable EqCongruence_resources : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> resources_ x1 x2 = resources_ y1 y2 .
Variable number_of_organizations_ : Universe -> Universe -> Universe.
Variable EqCongruence_number_of_organizations : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> number_of_organizations_ x1 x2 = number_of_organizations_ y1 y2 .
Variable first_movers_ : Universe.
Variable equilibrium_ : Universe -> Universe.
Variable EqCongruence_equilibrium : forall x1 y1 : Universe, x1 = y1 -> equilibrium_ x1 = equilibrium_ y1 .
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_disbanding_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disbanding_rate_ x1 x2 = disbanding_rate_ y1 y2 .
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable mp_time_point_in_environment_1 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_environment_not_empty_2 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (number_of_organizations_ E T) zero_)).
Variable mp_increase_not_decrease_3 : (forall X : Universe, (increases_ X -> ~(decreases_ X))).
Variable mp_greater_or_equal_4 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable a3_5 : (forall E T : Universe, ((environment_ E /\ (in_environment_ E T /\ greater_ (number_of_organizations_ E T) zero_)) -> ((greater_ (equilibrium_ E) T -> decreases_ (resources_ E T)) /\ (~(greater_ (equilibrium_ E) T) -> constant_ (resources_ E T))))).
Variable l4_6 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ((decreases_ (resources_ E T) -> increases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))) /\ (constant_ (resources_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))))).

Set Firstorder Depth 10.

Theorem prove_l3_7 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
