(*
% File     : MGT020+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : First movers exceeds efficient producers disbanding rate
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam95]
% Names    : LEMMA 2 [PM93]
%          : L2 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :   11 (   0 unit)
%            Number of atoms       :   42 (   1 equality)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   33 (   2 ~  ;   1  |;  16  &)
%                                         (   0 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-4 arity)
%            Number of functors    :    6 (   2 constant; 0-2 arity)
%            Number of variables   :   26 (   0 singleton;  26 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : Same as version with [PM93] axioms.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .
Variable decreases_ : Universe -> Prop.
Variable EqCongruence_decreases : forall x1 y1 : Universe, x1 = y1 -> decreases_ x1 -> decreases_ y1 .

Variable start_time_ : Universe -> Universe.
Variable EqCongruence_start_time : forall x1 y1 : Universe, x1 = y1 -> start_time_ x1 = start_time_ y1 .
Variable initial_FM_EP_ : Universe -> Universe.
Variable EqCongruence_initial_FM_EP : forall x1 y1 : Universe, x1 = y1 -> initial_FM_EP_ x1 = initial_FM_EP_ y1 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_disbanding_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disbanding_rate_ x1 x2 = disbanding_rate_ y1 y2 .
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable l3_1 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> ~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))))).
Variable mp_earliest_time_point_2 : (forall E T : Universe, (environment_ E -> ((in_environment_ E (initial_FM_EP_ E) -> subpopulations_ first_movers_ efficient_producers_ E (initial_FM_EP_ E)) /\ (subpopulations_ first_movers_ efficient_producers_ E T -> greater_or_equal_ T (initial_FM_EP_ E))))).
Variable mp_positive_function_difference_3 : (forall E T T1 T2 : Universe, ((environment_ E /\ (greater_or_equal_ T T1 /\ (greater_or_equal_ T2 T /\ (subpopulations_ first_movers_ efficient_producers_ E T2 /\ greater_ (disbanding_rate_ first_movers_ T1) (disbanding_rate_ efficient_producers_ T1))))) -> (~(decreases_ (difference_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))) -> greater_ (disbanding_rate_ first_movers_ T2) (disbanding_rate_ efficient_producers_ T2)))).
Variable mp_time_point_occurs_4 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> in_environment_ E T)).
Variable mp_initial_time_5 : (forall E : Universe, (environment_ E -> greater_or_equal_ (initial_FM_EP_ E) (start_time_ E))).
Variable mp_times_in_order_6 : (forall E T1 T2 : Universe, ((environment_ E /\ (greater_or_equal_ T1 (start_time_ E) /\ (greater_ T2 T1 /\ in_environment_ E T2))) -> in_environment_ E T1)).
Variable mp_greater_transitivity_7 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp_greater_or_equal_8 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable a8_9 : (forall E : Universe, (environment_ E -> greater_ (disbanding_rate_ first_movers_ (initial_FM_EP_ E)) (disbanding_rate_ efficient_producers_ (initial_FM_EP_ E)))).
Variable a10_10 : (forall E T1 T2 T : Universe, ((environment_ E /\ (subpopulations_ first_movers_ efficient_producers_ E T1 /\ (subpopulations_ first_movers_ efficient_producers_ E T2 /\ (greater_or_equal_ T T1 /\ greater_or_equal_ T2 T)))) -> subpopulations_ first_movers_ efficient_producers_ E T)).

Set Firstorder Depth 10.

Theorem prove_l2_11 : (forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
