(*
% File     : MGT019+2 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Growth rate of EPs exceeds that of FMs in stable environments
% Version  : [PM93] axioms.
% English  : The growth rate of efficent producers exceeds the growth rate 
%            of first movers past a certain time in stable environments.
% Refs     : [PM93]  Peli & Masuch (1993), The Logic of Propogation Strateg
%          : [PM94]  Peli & Masuch (1994), The Logic of Propogation Strateg
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing
% Source   : [PM93]
% Names    : LEMMA 1 [PM93]
%          : L1 [PB+94]
% Status   : CounterSatisfiable
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   21 (   1 equality)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   17 (   1 ~  ;   1  |;   8  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-4 arity)
%            Number of functors    :    5 (   2 constant; 0-2 arity)
%            Number of variables   :   11 (   0 singleton;   9 !;   2 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : There is no MGT019+1 as Kamps did not send it to me.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subpopulations_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_subpopulations : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> subpopulations_ x1 x2 x3 x4 -> subpopulations_ y1 y2 y3 y4 .
Variable stable_ : Universe -> Prop.
Variable EqCongruence_stable : forall x1 y1 : Universe, x1 = y1 -> stable_ x1 -> stable_ y1 .
Variable in_environment_ : Universe -> Universe -> Prop.
Variable EqCongruence_in_environment : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_environment_ x1 x2 -> in_environment_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable environment_ : Universe -> Prop.
Variable EqCongruence_environment : forall x1 y1 : Universe, x1 = y1 -> environment_ x1 -> environment_ y1 .

Variable growth_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_growth_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> growth_rate_ x1 x2 = growth_rate_ y1 y2 .
Variable founding_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_founding_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> founding_rate_ x1 x2 = founding_rate_ y1 y2 .
Variable first_movers_ : Universe.
Variable efficient_producers_ : Universe.
Variable disbanding_rate_ : Universe -> Universe -> Universe.
Variable EqCongruence_disbanding_rate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disbanding_rate_ x1 x2 = disbanding_rate_ y1 y2 .

Variable l2_1 : ~((forall E T : Universe, ((environment_ E /\ subpopulations_ first_movers_ efficient_producers_ E T) -> greater_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T)))).
Variable mp_EP_lower_disbanding_rate_2 : (forall T : Universe, ((greater_ (disbanding_rate_ first_movers_ T) (disbanding_rate_ efficient_producers_ T) /\ greater_or_equal_ (founding_rate_ efficient_producers_ T) (founding_rate_ first_movers_ T)) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))).
Variable mp_greater_or_equal_3 : (forall X Y : Universe, (greater_or_equal_ X Y -> (greater_ X Y \/ X = Y))).
Variable a8_4 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_or_equal_ (founding_rate_ efficient_producers_ T) (founding_rate_ first_movers_ T))))))).

Set Firstorder Depth 10.

Theorem prove_l1_5 : (forall E : Universe, ((environment_ E /\ stable_ E) -> (exists To : Universe, (in_environment_ E To /\ (forall T : Universe, ((subpopulations_ first_movers_ efficient_producers_ E T /\ greater_or_equal_ T To) -> greater_ (growth_rate_ efficient_producers_ T) (growth_rate_ first_movers_ T))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
