(*
% File     : MGT017+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Length of reoganisation proportional to organization size
% Version  : [PB+94] axioms.
% English  : The length of reorganizational period grows by the size the
%            organization begins reorganization (if the bigger organization
%            survives it).
% Refs     : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
%          : [Kam95] Kamps (1995), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    :
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   38 (   0 equality)
%            Maximal formula depth :   22 (  17 average)
%            Number of connectives :   34 (   0 ~  ;   0  |;  30  &)
%                                         (   0 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   30 (   0 singleton;  29 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Not published due to publication constraints. [Kam95].
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable size_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_type_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable inertia_ : Universe -> Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable class_ : Universe -> Universe -> Universe -> Prop.


Variable mp5_1 : (forall X T : Universe, (organization_ X T -> (exists I : Universe, inertia_ X I T))).
Variable a5_FOL_2 : (forall X Y C S1 S2 I1 I2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (class_ X C T1 /\ (class_ Y C T2 /\ (size_ X S1 T1 /\ (size_ Y S2 T2 /\ (inertia_ X I1 T1 /\ (inertia_ Y I2 T2 /\ greater_ S2 S1)))))))) -> greater_ I2 I1)).
Variable a13_FOL_3 : (forall X Y Rt C I1 I2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ Y Tc /\ (class_ X C Ta /\ (class_ Y C Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Rt Ta /\ (reorganization_type_ Y Rt Ta /\ (inertia_ X I1 Ta /\ (inertia_ Y I2 Ta /\ greater_ I2 I1))))))))))) -> greater_ Tc Tb)).

Set Firstorder Depth 10.

Theorem t17_FOL_4 : (forall X Y Rt C S1 S2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ Y Tc /\ (class_ X C Ta /\ (class_ Y C Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Rt Ta /\ (reorganization_type_ Y Rt Ta /\ (size_ X S1 Ta /\ (size_ Y S2 Ta /\ greater_ S2 S1))))))))))) -> greater_ Tc Tb)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
