(*
% File     : MGT011+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Organizational size cannot decrease without reorganization
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 11 [PB+92]
%          : T11FOL1 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    8 (   0 unit)
%            Number of atoms       :   38 (   2 equality)
%            Maximal formula depth :   19 (   9 average)
%            Number of connectives :   33 (   3 ~  ;   0  |;  24  &)
%                                         (   0 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   34 (   0 singleton;  32 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable size_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_size : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> size_ x1 x2 x3 -> size_ y1 y2 y3 .
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_reorganization_free : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> reorganization_free_ x1 x2 x3 -> reorganization_free_ y1 y2 y3 .
Variable organization_ : Universe -> Universe -> Prop.
Variable EqCongruence_organization : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> organization_ x1 x2 -> organization_ y1 y2 .
Variable inertia_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_inertia : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> inertia_ x1 x2 x3 -> inertia_ y1 y2 y3 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable class_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_class : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> class_ x1 x2 x3 -> class_ y1 y2 y3 .


Variable mp5_1 : (forall X T : Universe, (organization_ X T -> (exists I : Universe, inertia_ X I T))).
Variable mp6_1_2 : (forall X Y : Universe, ~((greater_ X Y /\ X = Y))).
Variable mp6_2_3 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable mp9_4 : (forall X T : Universe, (organization_ X T -> (exists C : Universe, class_ X C T))).
Variable mp10_5 : (forall X T1 T2 C1 C2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (class_ X C1 T1 /\ class_ X C2 T2)))) -> C1 = C2)).
Variable a5_FOL_6 : (forall X Y C S1 S2 I1 I2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (class_ X C T1 /\ (class_ Y C T2 /\ (size_ X S1 T1 /\ (size_ Y S2 T2 /\ (inertia_ X I1 T1 /\ (inertia_ Y I2 T2 /\ greater_ S2 S1)))))))) -> greater_ I2 I1)).
Variable t2_FOL_7 : (forall X I1 I2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (inertia_ X I1 T1 /\ (inertia_ X I2 T2 /\ greater_ T2 T1))))) -> greater_ I2 I1)).

Set Firstorder Depth 10.

Theorem t11_FOL_8 : (forall X S1 S2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (size_ X S1 T1 /\ (size_ X S2 T2 /\ greater_ T2 T1))))) -> ~(greater_ S1 S2))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
