(*
% File     : MGT010+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Large organization have higher reliability and accountability
% Version  : [PB+94] axioms.
% English  : Large organization have higher reliability and accountability
%            than small organizations (of the same class).
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 10 [PB+92]
%          : T10FOL1 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   40 (   0 equality)
%            Maximal formula depth :   25 (  18 average)
%            Number of connectives :   36 (   0 ~  ;   0  |;  31  &)
%                                         (   1 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   33 (   0 singleton;  32 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable size_ : Universe -> Universe -> Universe -> Prop.
Variable reproducibility_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable reliability_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable class_ : Universe -> Universe -> Universe -> Prop.
Variable accountability_ : Universe -> Universe -> Universe -> Prop.


Variable mp3_1 : (forall X T : Universe, (organization_ X T -> (exists Rp : Universe, reproducibility_ X Rp T))).
Variable a2_FOL_2 : (forall X Y T1 T2 R1 R2 A1 A2 Rp1 Rp2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reliability_ X R1 T1 /\ (reliability_ Y R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ Y A2 T2 /\ (reproducibility_ X Rp1 T1 /\ reproducibility_ Y Rp2 T2))))))) -> (greater_ Rp2 Rp1 <-> (greater_ R2 R1 /\ greater_ A2 A1)))).
Variable t9_FOL_3 : (forall X Y C Rp1 Rp2 S1 S2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (class_ X C T1 /\ (class_ Y C T2 /\ (reproducibility_ X Rp1 T1 /\ (reproducibility_ Y Rp2 T2 /\ (size_ X S1 T1 /\ (size_ Y S2 T2 /\ greater_ S2 S1)))))))))) -> greater_ Rp2 Rp1)).

Set Firstorder Depth 10.

Theorem t10_FOL_4 : (forall X Y C R1 R2 A1 A2 S1 S2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reorganization_free_ X T1 T1 /\ (reorganization_free_ Y T2 T2 /\ (class_ X C T1 /\ (class_ Y C T2 /\ (reliability_ X R1 T1 /\ (reliability_ Y R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ Y A2 T2 /\ (size_ X S1 T1 /\ (size_ Y S2 T2 /\ greater_ S2 S1)))))))))))) -> (greater_ R2 R1 /\ greater_ A2 A1))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
