(*
% File     : MGT007+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Reproducibility decreases during reorganization.
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 7 [PB+92]
%          : T7FOL1 [PB+94]
% Status   : Theorem
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Rating (intuit.) : 1.00 v1.1
% Syntax   : Number of formulae    :    6 (   0 unit)
%            Number of atoms       :   38 (   0 equality)
%            Maximal formula depth :   21 (  12 average)
%            Number of connectives :   36 (   4 ~  ;   0  |;  25  &)
%                                         (   1 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   35 (   0 singleton;  32 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable reproducibility_ : Universe -> Universe -> Universe -> Prop.
Variable reorganization_ : Universe -> Universe -> Universe -> Prop.
Variable reliability_ : Universe -> Universe -> Universe -> Prop.
Variable organization_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable accountability_ : Universe -> Universe -> Universe -> Prop.


Variable mp1_1 : (forall X T : Universe, (organization_ X T -> (exists R : Universe, reliability_ X R T))).
Variable mp2_2 : (forall X T : Universe, (organization_ X T -> (exists A : Universe, accountability_ X A T))).
Variable mp_not_in_TR_3 : (forall X T : Universe, (organization_ X T -> (exists A : Universe, reproducibility_ X A T))).
Variable a2_FOL_4 : (forall X Y T1 T2 R1 R2 A1 A2 Rp1 Rp2 : Universe, ((organization_ X T1 /\ (organization_ Y T2 /\ (reliability_ X R1 T1 /\ (reliability_ Y R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ Y A2 T2 /\ (reproducibility_ X Rp1 T1 /\ reproducibility_ Y Rp2 T2))))))) -> (greater_ Rp2 Rp1 <-> (greater_ R2 R1 /\ greater_ A2 A1)))).
Variable a6_FOL_5 : (forall X R1 R2 A1 A2 T1 T2 Ta Tb : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_ X Ta Tb /\ (reliability_ X R1 T1 /\ (reliability_ X R2 T2 /\ (accountability_ X A1 T1 /\ (accountability_ X A2 T2 /\ (~(greater_ Ta T1) /\ (greater_ T2 T1 /\ ~(greater_ T2 Tb)))))))))) -> (greater_ R1 R2 /\ greater_ A1 A2))).

Set Firstorder Depth 10.

Theorem t7_FOL_6 : (forall X Rp1 Rp2 T1 T2 Ta Tb : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_ X Ta Tb /\ (reproducibility_ X Rp1 T1 /\ (reproducibility_ X Rp2 T2 /\ (~(greater_ Ta T1) /\ (greater_ T2 T1 /\ ~(greater_ T2 Tb)))))))) -> greater_ Rp1 Rp2)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
