(*
% File     : MGT005+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Complexity increases the risk of death due to reorganization.
% Version  : [PB+94] axioms.
% English  : 
% Refs     : [PB+92] Peli et al. (1992), A Logical Approach to Formalizing
%          : [PB+94] Peli et al. (1994), A Logical Approach to Formalizing 
%          : [Kam94] Kamps (1994), Email to G. Sutcliffe
% Source   : [Kam94]
% Names    : THEOREM 5 [PB+92]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.50 v2.7.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   11 (   0 unit)
%            Number of atoms       :   83 (   2 equality)
%            Maximal formula depth :   31 (  13 average)
%            Number of connectives :   76 (   4 ~  ;   1  |;  62  &)
%                                         (   0 <=>;   9 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 2-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   62 (   0 singleton;  61 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : mp11, mp12 and mp13 corrospond to mp10, mp11 and mp12
%            respectively from [PB+92]
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable survival_chance_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_survival_chance : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> survival_chance_ x1 x2 x3 -> survival_chance_ y1 y2 y3 .
Variable reorganization_type_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_reorganization_type : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> reorganization_type_ x1 x2 x3 -> reorganization_type_ y1 y2 y3 .
Variable reorganization_free_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_reorganization_free : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> reorganization_free_ x1 x2 x3 -> reorganization_free_ y1 y2 y3 .
Variable reorganization_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_reorganization : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> reorganization_ x1 x2 x3 -> reorganization_ y1 y2 y3 .
Variable organization_ : Universe -> Universe -> Prop.
Variable EqCongruence_organization : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> organization_ x1 x2 -> organization_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable complexity_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_complexity : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> complexity_ x1 x2 x3 -> complexity_ y1 y2 y3 .
Variable class_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_class : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> class_ x1 x2 x3 -> class_ y1 y2 y3 .


Variable mp6_1_1 : (forall X Y : Universe, ~((greater_ X Y /\ X = Y))).
Variable mp6_2_2 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable mp11_3 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable mp12_4 : (forall X T : Universe, (organization_ X T -> (exists P : Universe, survival_chance_ X P T))).
Variable mp13_5 : (forall X T T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (greater_ T T1 /\ greater_ T2 T))) -> organization_ X T)).
Variable mp7_6 : (forall X Ta Tb : Universe, (reorganization_ X Ta Tb -> greater_ Tb Ta)).
Variable t3_FOL_7 : (forall X P1 P2 T1 T2 : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_free_ X T1 T2 /\ (survival_chance_ X P1 T1 /\ (survival_chance_ X P2 T2 /\ greater_ T2 T1))))) -> greater_ P2 P1)).
Variable t4_FOL_8 : (forall X P1 P2 T1 T2 Ta Tb : Universe, ((organization_ X T1 /\ (organization_ X T2 /\ (reorganization_ X Ta Tb /\ (survival_chance_ X P1 T1 /\ (survival_chance_ X P2 T2 /\ (~(greater_ Ta T1) /\ (greater_ T2 T1 /\ ~(greater_ T2 Tb)))))))) -> greater_ P1 P2)).
Variable a10_FOL_9 : (forall X Y Re C C1 C2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ Y Tc /\ (class_ X C Ta /\ (class_ Y C Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Re Ta /\ (reorganization_type_ Y Re Ta /\ (complexity_ X C1 Ta /\ (complexity_ Y C2 Ta /\ greater_ C2 C1))))))))))) -> greater_ Tc Tb)).
Variable a11_FOL_10 : (forall X Y Re C P P1 P2 C1 C2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ X Tb /\ (organization_ Y Tb /\ (class_ X C Ta /\ (class_ Y C Ta /\ (survival_chance_ X P Ta /\ (survival_chance_ Y P Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Re Ta /\ (reorganization_type_ Y Re Ta /\ (survival_chance_ X P1 Tb /\ (survival_chance_ Y P2 Tb /\ (complexity_ X C1 Ta /\ (complexity_ Y C2 Ta /\ greater_ C2 C1)))))))))))))))) -> (greater_ P1 P2 \/ P1 = P2))).

Set Firstorder Depth 10.

Theorem t5_FOL_11 : (forall X Y Re C P P1 P2 C1 C2 Ta Tb Tc : Universe, ((organization_ X Ta /\ (organization_ Y Ta /\ (organization_ X Tc /\ (organization_ Y Tc /\ (class_ X C Ta /\ (class_ Y C Ta /\ (survival_chance_ X P Ta /\ (survival_chance_ Y P Ta /\ (reorganization_ X Ta Tb /\ (reorganization_ Y Ta Tc /\ (reorganization_type_ X Re Ta /\ (reorganization_type_ Y Re Ta /\ (reorganization_free_ X Tb Tc /\ (survival_chance_ X P1 Tc /\ (survival_chance_ Y P2 Tc /\ (complexity_ X C1 Ta /\ (complexity_ Y C2 Ta /\ greater_ C2 C1))))))))))))))))) -> greater_ P1 P2)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
