(*
% File     : LCL354+1 : ILTP v1.1.2
% Domain   : Logic Calculi (Temporal)
% Problem  : Independence of an Axiom for Temporal Intervals
% Version  : [Zha98] axioms : Especial.
% English  : Shows that the 5th axiom of temporal intervals is not dependant
%            on the first three by building a model of the first three and
%            the negation of the 5th.
% Refs     : [Zha98] Zhang (1998), Showing the Independence of An Axiom for
% Source   : [Zha98]
% Names    : - [Zha98]
% Status   : Satisfiable
% Rating   : 0.67 v2.6.0, 0.50 v2.5.0, 0.33 v2.4.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   18 (   0 equality)
%            Maximal formula depth :   11 (   8 average)
%            Number of connectives :   15 (   1 ~  ;   0  |;   9  &)
%                                         (   0 <=>;   3 =>;   0 <=)
%                                         (   2 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   18 (   0 singleton;  11 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable meets_ : Universe -> Universe -> Prop.


Variable m1_1 : (forall P Q R S : Universe, ((meets_ P Q /\ (meets_ P S /\ meets_ R Q)) -> meets_ R S)).
Variable m2_2 : (forall P Q R S : Universe, ((meets_ P Q /\ meets_ R S) -> ((((meets_ P S \/ (exists T : Universe, (meets_ P T /\ meets_ T S))) /\ ~(meets_ P S /\ (exists T : Universe, (meets_ P T /\ meets_ T S)))) \/ (exists T : Universe, (meets_ R T /\ meets_ T Q))) /\ ~(((meets_ P S \/ (exists T : Universe, (meets_ P T /\ meets_ T S))) /\ ~(meets_ P S /\ (exists T : Universe, (meets_ P T /\ meets_ T S)))) /\ (exists T : Universe, (meets_ R T /\ meets_ T Q)))))).
Variable m3_3 : (forall P : Universe, (exists Q R : Universe, (meets_ Q P /\ meets_ P R))).
Variable not_m5_4 : ~((forall P Q : Universe, (meets_ P Q -> (exists R S T : Universe, (meets_ R P /\ (meets_ Q S /\ (meets_ R T /\ meets_ T S))))))).

Theorem conjecture_5 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
