(*
% File     : KRS173+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A simple infinite loop for implementors to avoid
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_someValuesFrom-Manifest003 [Bec03]
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    5 (   1 unit)
%            Number of atoms       :   17 (   0 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   16 (   4 ~  ;   0  |;   9  &)
%                                         (   3 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :    6 (   0 singleton;   5 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rparent_ : Universe -> Universe -> Prop.
Variable cperson_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.

Variable ifred_ : Universe.
Variable i2003_11_14_17_14_14998_ : Universe.
Variable i2003_11_14_17_14_14920_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cperson_ X <-> (exists Y : Universe, (rparent_ X Y /\ cperson_ Y)))).
Variable axiom_3_4 : cperson_ ifred_.

Set Firstorder Depth 10.

Theorem the_axiom_5 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ ifred_ /\ (rparent_ ifred_ i2003_11_14_17_14_14998_ /\ (cowlThing_ i2003_11_14_17_14_14920_ /\ (cowlThing_ i2003_11_14_17_14_14998_ /\ rparent_ i2003_11_14_17_14_14998_ i2003_11_14_17_14_14920_)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
