(*
% File     : KRS172+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : The same property extension means equivalentProperty
% Version  : Especial.
% English  : If p and q have the same property extension then p 
%            equivalentProperty q.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_equivalentProperty-Manifest004 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   19 (   1 unit)
%            Number of atoms       :   52 (  11 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   37 (   4 ~  ;   0  |;  15  &)
%                                         (   5 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   40 (   0 singleton;  40 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rq_ : Universe -> Universe -> Prop.
Variable EqCongruence_rq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rq_ x1 x2 -> rq_ y1 y2 .
Variable rp_ : Universe -> Universe -> Prop.
Variable EqCongruence_rp : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rp_ x1 x2 -> rp_ y1 y2 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cd_ : Universe -> Prop.
Variable EqCongruence_cd : forall x1 y1 : Universe, x1 = y1 -> cd_ x1 -> cd_ y1 .

Variable iv_ : Universe.

Variable cd_substitution_1_1 : (forall A B : Universe, ((A = B /\ cd_ A) -> cd_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rp_substitution_1_4 : (forall A B C : Universe, ((A = B /\ rp_ A C) -> rp_ B C)).
Variable rp_substitution_2_5 : (forall A B C : Universe, ((A = B /\ rp_ C A) -> rp_ C B)).
Variable rq_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rq_ A C) -> rq_ B C)).
Variable rq_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rq_ C A) -> rq_ C B)).
Variable xsd_integer_substitution_1_8 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_9 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_10 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_11 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_12 : (forall X : Universe, (cd_ X <-> rq_ X iv_)).
Variable axiom_3_13 : (forall X : Universe, (cd_ X <-> rp_ X iv_)).
Variable axiom_4_14 : (forall X Y Z : Universe, ((rp_ X Y /\ rp_ X Z) -> Y = Z)).
Variable axiom_5_15 : (forall X Y : Universe, (rp_ X Y -> cd_ X)).
Variable axiom_6_16 : (forall X Y Z : Universe, ((rq_ X Y /\ rq_ X Z) -> Y = Z)).
Variable axiom_7_17 : (forall X Y : Universe, (rq_ X Y -> cd_ X)).
Variable axiom_8_18 : cowlThing_ iv_.

Set Firstorder Depth 10.

Theorem the_axiom_19 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (forall X Y : Universe, (rq_ X Y <-> rp_ X Y)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
