(*
% File     : KRS170+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Deduction from hasLeader
% Version  : Especial.
% English  : A reasoner can also deduce that hasLeader is a subProperty of 
%            hasHead and hasHead is a subProperty of hasLeader.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_equivalentProperty-Manifest002 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.1.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   14 (   0 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   14 (   4 ~  ;   0  |;   5  &)
%                                         (   3 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   10 (   0 singleton;  10 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rhasLeader_ : Universe -> Universe -> Prop.
Variable rhasHead_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.


Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X Y : Universe, (rhasLeader_ X Y <-> rhasHead_ X Y)).

Set Firstorder Depth 10.

Theorem the_axiom_4 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ ((forall X Y : Universe, (rhasLeader_ X Y -> rhasHead_ X Y)) /\ (forall X Y : Universe, (rhasHead_ X Y -> rhasLeader_ X Y))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
