(*
% File     : KRS169+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : hasLeader may be stated as the owl:equivalentProperty of hasHead
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_equivalentProperty-Manifest001 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Syntax   : Number of formulae    :    7 (   3 unit)
%            Number of atoms       :   16 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   13 (   4 ~  ;   0  |;   6  &)
%                                         (   3 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :    6 (   0 singleton;   6 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rhasLeader_ : Universe -> Universe -> Prop.
Variable rhasHead_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.

Variable iY_ : Universe.
Variable iX_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : cowlThing_ iX_.
Variable axiom_3_4 : rhasLeader_ iX_ iY_.
Variable axiom_4_5 : cowlThing_ iY_.
Variable axiom_5_6 : (forall X Y : Universe, (rhasLeader_ X Y <-> rhasHead_ X Y)).

Set Firstorder Depth 10.

Theorem the_axiom_7 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cowlThing_ iX_ /\ (rhasHead_ iX_ iY_ /\ cowlThing_ iY_)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
