(*
% File     : KRS164+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Two classes may have the same class extension
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_equivalentClass-Manifest001 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Syntax   : Number of formulae    :    8 (   4 unit)
%            Number of atoms       :   18 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   14 (   4 ~  ;   0  |;   7  &)
%                                         (   3 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-1 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :    5 (   0 singleton;   5 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cCar_ : Universe -> Prop.
Variable cAutomobile_ : Universe -> Prop.

Variable icar_ : Universe.
Variable iauto_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cCar_ X <-> cAutomobile_ X)).
Variable axiom_3_4 : cAutomobile_ iauto_.
Variable axiom_4_5 : cowlThing_ iauto_.
Variable axiom_5_6 : cCar_ icar_.
Variable axiom_6_7 : cowlThing_ icar_.

Set Firstorder Depth 10.

Theorem the_axiom_8 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cCar_ iauto_ /\ (cowlThing_ iauto_ /\ (cAutomobile_ icar_ /\ cowlThing_ icar_))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
