(*
% File     : KRS162+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Entailment for three natural numbers
% Version  : Especial.
% English  : This entailment can be replicated for any three natural numbers 
%            i, j, k such that i+j >= k. In this example, they are chosen as 
%            2, 3 and 5.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest901 [Bec03]
% Status   : Theorem
% Rating   : 0.33 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   20 (   0 unit)
%            Number of atoms       :   78 (  26 equality)
%            Maximal formula depth :   25 (   6 average)
%            Number of connectives :   77 (  19 ~  ;   0  |;  39  &)
%                                         (   2 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   54 (   0 singleton;  44 !;  10 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable rq_ : Universe -> Universe -> Prop.
Variable EqCongruence_rq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rq_ x1 x2 -> rq_ y1 y2 .
Variable rp_ : Universe -> Universe -> Prop.
Variable EqCongruence_rp : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rp_ x1 x2 -> rp_ y1 y2 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cB_ : Universe -> Prop.
Variable EqCongruence_cB : forall x1 y1 : Universe, x1 = y1 -> cB_ x1 -> cB_ y1 .
Variable cA_ : Universe -> Prop.
Variable EqCongruence_cA : forall x1 y1 : Universe, x1 = y1 -> cA_ x1 -> cA_ y1 .


Variable cA_substitution_1_1 : (forall A B : Universe, ((A = B /\ cA_ A) -> cA_ B)).
Variable cB_substitution_1_2 : (forall A B : Universe, ((A = B /\ cB_ A) -> cB_ B)).
Variable cowlNothing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_4 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rp_substitution_1_5 : (forall A B C : Universe, ((A = B /\ rp_ A C) -> rp_ B C)).
Variable rp_substitution_2_6 : (forall A B C : Universe, ((A = B /\ rp_ C A) -> rp_ C B)).
Variable rq_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rq_ A C) -> rq_ B C)).
Variable rq_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rq_ C A) -> rq_ C B)).
Variable rr_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_11 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_13 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_14 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_15 : (forall X Y : Universe, (rp_ X Y -> cA_ Y)).
Variable axiom_3_16 : (forall X Y : Universe, (rq_ X Y -> cB_ Y)).
Variable axiom_4_17 : (forall X : Universe, ~((cB_ X /\ cA_ X))).
Variable axiom_5_18 : (forall X Y : Universe, (rq_ X Y -> rr_ X Y)).
Variable axiom_6_19 : (forall X Y : Universe, (rp_ X Y -> rr_ X Y)).

Set Firstorder Depth 10.

Theorem the_axiom_20 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (forall X : Universe, (((exists Y0 Y1 : Universe, (rp_ X Y0 /\ (rp_ X Y1 /\ Y0 <> Y1))) /\ (exists Y0 Y1 Y2 : Universe, (rq_ X Y0 /\ (rq_ X Y1 /\ (rq_ X Y2 /\ (Y0 <> Y1 /\ (Y0 <> Y2 /\ Y1 <> Y2))))))) -> (exists Y0 Y1 Y2 Y3 Y4 : Universe, (rr_ X Y0 /\ (rr_ X Y1 /\ (rr_ X Y2 /\ (rr_ X Y3 /\ (rr_ X Y4 /\ (Y0 <> Y1 /\ (Y0 <> Y2 /\ (Y0 <> Y3 /\ (Y0 <> Y4 /\ (Y1 <> Y2 /\ (Y1 <> Y3 /\ (Y1 <> Y4 /\ (Y2 <> Y3 /\ (Y2 <> Y4 /\ Y3 <> Y4))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
