(*
% File     : KRS148+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: k_dum ABox test from DL98 systems comparison
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_description-logic-Manifest203 [Bec03]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   90 (  13 unit)
%            Number of atoms       :  243 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :  207 (  54 ~  ;   0  |;  77  &)
%                                         (  72 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   77 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :  116 (   0 singleton;  78 !;  38 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rR1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cTOP_ : Universe -> Prop.
Variable cTEST_ : Universe -> Prop.
Variable cC98_ : Universe -> Prop.
Variable cC96_ : Universe -> Prop.
Variable cC94_ : Universe -> Prop.
Variable cC92_ : Universe -> Prop.
Variable cC90_ : Universe -> Prop.
Variable cC88_ : Universe -> Prop.
Variable cC86_ : Universe -> Prop.
Variable cC84_ : Universe -> Prop.
Variable cC82_ : Universe -> Prop.
Variable cC80_ : Universe -> Prop.
Variable cC8_ : Universe -> Prop.
Variable cC78_ : Universe -> Prop.
Variable cC76_ : Universe -> Prop.
Variable cC74_ : Universe -> Prop.
Variable cC72_ : Universe -> Prop.
Variable cC70_ : Universe -> Prop.
Variable cC68_ : Universe -> Prop.
Variable cC66_ : Universe -> Prop.
Variable cC64_ : Universe -> Prop.
Variable cC62_ : Universe -> Prop.
Variable cC60_ : Universe -> Prop.
Variable cC6_ : Universe -> Prop.
Variable cC58_ : Universe -> Prop.
Variable cC56_ : Universe -> Prop.
Variable cC54_ : Universe -> Prop.
Variable cC52_ : Universe -> Prop.
Variable cC50_ : Universe -> Prop.
Variable cC48_ : Universe -> Prop.
Variable cC46_ : Universe -> Prop.
Variable cC44_ : Universe -> Prop.
Variable cC42_ : Universe -> Prop.
Variable cC40_ : Universe -> Prop.
Variable cC4_ : Universe -> Prop.
Variable cC38_ : Universe -> Prop.
Variable cC36_ : Universe -> Prop.
Variable cC34_ : Universe -> Prop.
Variable cC32_ : Universe -> Prop.
Variable cC30_ : Universe -> Prop.
Variable cC28_ : Universe -> Prop.
Variable cC26_ : Universe -> Prop.
Variable cC24_ : Universe -> Prop.
Variable cC22_ : Universe -> Prop.
Variable cC20_ : Universe -> Prop.
Variable cC2_ : Universe -> Prop.
Variable cC18_ : Universe -> Prop.
Variable cC16_ : Universe -> Prop.
Variable cC140_ : Universe -> Prop.
Variable cC14_ : Universe -> Prop.
Variable cC138_ : Universe -> Prop.
Variable cC136_ : Universe -> Prop.
Variable cC134_ : Universe -> Prop.
Variable cC132_ : Universe -> Prop.
Variable cC130_ : Universe -> Prop.
Variable cC128_ : Universe -> Prop.
Variable cC126_ : Universe -> Prop.
Variable cC124_ : Universe -> Prop.
Variable cC122_ : Universe -> Prop.
Variable cC120_ : Universe -> Prop.
Variable cC12_ : Universe -> Prop.
Variable cC118_ : Universe -> Prop.
Variable cC116_ : Universe -> Prop.
Variable cC114_ : Universe -> Prop.
Variable cC112_ : Universe -> Prop.
Variable cC110_ : Universe -> Prop.
Variable cC108_ : Universe -> Prop.
Variable cC106_ : Universe -> Prop.
Variable cC104_ : Universe -> Prop.
Variable cC102_ : Universe -> Prop.
Variable cC100_ : Universe -> Prop.
Variable cC10_ : Universe -> Prop.

Variable iV5478_ : Universe.
Variable iV5476_ : Universe.
Variable iV5475_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cC10_ X <-> (~(cC8_ X) /\ ~(cC2_ X)))).
Variable axiom_3_4 : (forall X : Universe, (cC100_ X <-> (~(cC98_ X) /\ cC94_ X))).
Variable axiom_4_5 : (forall X : Universe, (cC102_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC100_ Y)))).
Variable axiom_5_6 : (forall X : Universe, (cC104_ X <-> (~(cC102_ X) /\ cC88_ X))).
Variable axiom_6_7 : (forall X : Universe, (cC106_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC104_ Y)))).
Variable axiom_7_8 : (forall X : Universe, (cC108_ X <-> (cC84_ X /\ ~(cC106_ X)))).
Variable axiom_8_9 : (forall X : Universe, (cC110_ X <-> (cC62_ X /\ ~(cC108_ X)))).
Variable axiom_9_10 : (forall X : Universe, (cC112_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC110_ Y))))).
Variable axiom_10_11 : (forall X : Universe, (cC114_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC112_ Y)))).
Variable axiom_11_12 : (forall X : Universe, (cC116_ X <-> (cTOP_ X /\ ~(cC114_ X)))).
Variable axiom_12_13 : (forall X : Universe, (cC118_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_13_14 : (forall X : Universe, (cC12_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC10_ Y)))).
Variable axiom_14_15 : (forall X : Universe, (cC120_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC118_ Y))))).
Variable axiom_15_16 : (forall X : Universe, (cC122_ X <-> (~(cC2_ X) /\ cC120_ X))).
Variable axiom_16_17 : (forall X : Universe, (cC124_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_17_18 : (forall X : Universe, (cC126_ X <-> (cC124_ X /\ cC2_ X))).
Variable axiom_18_19 : (forall X : Universe, (cC128_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC126_ Y)))).
Variable axiom_19_20 : (forall X : Universe, (cC130_ X <-> (~(cC2_ X) /\ ~(cC128_ X)))).
Variable axiom_20_21 : (forall X : Universe, (cC132_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC130_ Y)))).
Variable axiom_21_22 : (forall X : Universe, (cC134_ X <-> (cC122_ X /\ ~(cC132_ X)))).
Variable axiom_22_23 : (forall X : Universe, (cC136_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC134_ Y)))).
Variable axiom_23_24 : (forall X : Universe, (cC138_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC136_ Y)))).
Variable axiom_24_25 : (forall X : Universe, (cC14_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC12_ Y)))).
Variable axiom_25_26 : (forall X : Universe, (cC140_ X <-> (cTOP_ X /\ cC138_ X))).
Variable axiom_26_27 : (forall X : Universe, (cC16_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_27_28 : (forall X : Universe, (cC18_ X <-> (cC16_ X /\ cC2_ X))).
Variable axiom_28_29 : (forall X : Universe, (cC20_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC18_ Y)))).
Variable axiom_29_30 : (forall X : Universe, (cC22_ X <-> (~(cC20_ X) /\ ~(cC2_ X)))).
Variable axiom_30_31 : (forall X : Universe, (cC24_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC22_ Y)))).
Variable axiom_31_32 : (forall X : Universe, (cC26_ X <-> (cC14_ X /\ ~(cC24_ X)))).
Variable axiom_32_33 : (forall X : Universe, (cC28_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_33_34 : (forall X : Universe, (cC30_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC28_ Y)))).
Variable axiom_34_35 : (forall X : Universe, (cC32_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_35_36 : (forall X : Universe, (cC34_ X <-> (cC30_ X /\ ~(cC32_ X)))).
Variable axiom_36_37 : (forall X : Universe, (cC36_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC34_ Y)))).
Variable axiom_37_38 : (forall X : Universe, (cC38_ X <-> (~(cC36_ X) /\ ~(cC26_ X)))).
Variable axiom_38_39 : (forall X : Universe, (cC4_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_39_40 : (forall X : Universe, (cC40_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_40_41 : (forall X : Universe, (cC42_ X <-> (~(cC2_ X) /\ cC40_ X))).
Variable axiom_41_42 : (forall X : Universe, (cC44_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_42_43 : (forall X : Universe, (cC46_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC44_ Y))))).
Variable axiom_43_44 : (forall X : Universe, (cC48_ X <-> (cC42_ X /\ cC46_ X))).
Variable axiom_44_45 : (forall X : Universe, (cC50_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_45_46 : (forall X : Universe, (cC52_ X <-> (cC2_ X /\ cC50_ X))).
Variable axiom_46_47 : (forall X : Universe, (cC54_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC52_ Y)))).
Variable axiom_47_48 : (forall X : Universe, (cC56_ X <-> (~(cC54_ X) /\ ~(cC2_ X)))).
Variable axiom_48_49 : (forall X : Universe, (cC58_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC56_ Y)))).
Variable axiom_49_50 : (forall X : Universe, (cC6_ X <-> (cC2_ X /\ cC4_ X))).
Variable axiom_50_51 : (forall X : Universe, (cC60_ X <-> (cC48_ X /\ ~(cC58_ X)))).
Variable axiom_51_52 : (forall X : Universe, (cC62_ X <-> (cC38_ X /\ ~(cC60_ X)))).
Variable axiom_52_53 : (forall X : Universe, (cC64_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_53_54 : (forall X : Universe, (cC66_ X <-> (cC64_ X /\ cC2_ X))).
Variable axiom_54_55 : (forall X : Universe, (cC68_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_55_56 : (forall X : Universe, (cC70_ X <-> (cC2_ X /\ cC68_ X))).
Variable axiom_56_57 : (forall X : Universe, (cC72_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC70_ Y)))).
Variable axiom_57_58 : (forall X : Universe, (cC74_ X <-> (cC66_ X /\ cC72_ X))).
Variable axiom_58_59 : (forall X : Universe, (cC76_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_59_60 : (forall X : Universe, (cC78_ X <-> (cC76_ X /\ cC2_ X))).
Variable axiom_60_61 : (forall X : Universe, (cC8_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC6_ Y)))).
Variable axiom_61_62 : (forall X : Universe, (cC80_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC78_ Y)))).
Variable axiom_62_63 : (forall X : Universe, (cC82_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC80_ Y))))).
Variable axiom_63_64 : (forall X : Universe, (cC84_ X <-> (cC82_ X /\ cC74_ X))).
Variable axiom_64_65 : (forall X : Universe, (cC86_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_65_66 : (forall X : Universe, (cC88_ X <-> (cC86_ X /\ cC2_ X))).
Variable axiom_66_67 : (forall X : Universe, (cC90_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_67_68 : (forall X : Universe, (cC92_ X <-> (cC2_ X /\ cC90_ X))).
Variable axiom_68_69 : (forall X : Universe, (cC94_ X <-> (exists Y : Universe, (rR1_ X Y /\ cC92_ Y)))).
Variable axiom_69_70 : (forall X : Universe, (cC96_ X <-> (exists Y : Universe, (rR1_ X Y /\ ~(cC2_ Y))))).
Variable axiom_70_71 : (forall X : Universe, (cC98_ X <-> (cC96_ X /\ cC2_ X))).
Variable axiom_71_72 : (forall X : Universe, (cTEST_ X <-> (cC140_ X /\ cC116_ X))).
Variable axiom_72_73 : cTEST_ iV5475_.
Variable axiom_73_74 : cTOP_ iV5475_.
Variable axiom_74_75 : cowlThing_ iV5475_.
Variable axiom_75_76 : (forall X : Universe, (rR1_ iV5475_ X -> ~(cC112_ X))).
Variable axiom_76_77 : ~(cC114_ iV5475_).
Variable axiom_77_78 : rR1_ iV5475_ iV5476_.
Variable axiom_78_79 : cowlThing_ iV5476_.
Variable axiom_79_80 : ~(cC34_ iV5478_).
Variable axiom_80_81 : ~(cC12_ iV5478_).
Variable axiom_81_82 : (forall X : Universe, (rR1_ iV5478_ X -> cC2_ X)).
Variable axiom_82_83 : ~(cC30_ iV5478_).
Variable axiom_83_84 : ~(cC130_ iV5478_).
Variable axiom_84_85 : ~(cC118_ iV5478_).
Variable axiom_85_86 : cowlThing_ iV5478_.
Variable axiom_86_87 : cC2_ iV5478_.
Variable axiom_87_88 : (forall X : Universe, (rR1_ iV5478_ X -> ~(cC28_ X))).
Variable axiom_88_89 : (forall X : Universe, (rR1_ iV5478_ X -> ~(cC10_ X))).

Set Firstorder Depth 10.

Theorem the_axiom_90 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cC138_ iV5475_ /\ (cowlThing_ iV5475_ /\ (cC116_ iV5475_ /\ cC140_ iV5475_))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
