(*
% File     : KRS145+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : An owl:cardinality constraint is simply shorthand
% Version  : Especial.
% English  : An owl:cardinality constraint is simply shorthand for a pair of 
%            owl:minCardinality and owl:maxCardinality constraints.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_cardinality-Manifest004 [Bec03]
% Status   : Theorem
% Rating   : 0.22 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   11 (   0 unit)
%            Number of atoms       :   49 (  15 equality)
%            Maximal formula depth :   12 (   6 average)
%            Number of connectives :   44 (   6 ~  ;   4  |;  21  &)
%                                         (   2 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   32 (   0 singleton;  28 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rp_ : Universe -> Universe -> Prop.
Variable EqCongruence_rp : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rp_ x1 x2 -> rp_ y1 y2 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cc_ : Universe -> Prop.
Variable EqCongruence_cc : forall x1 y1 : Universe, x1 = y1 -> cc_ x1 -> cc_ y1 .


Variable cc_substitution_1_1 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable rp_substitution_1_4 : (forall A B C : Universe, ((A = B /\ rp_ A C) -> rp_ B C)).
Variable rp_substitution_2_5 : (forall A B C : Universe, ((A = B /\ rp_ C A) -> rp_ C B)).
Variable xsd_integer_substitution_1_6 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_7 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_8 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_9 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_10 : (forall X : Universe, (cc_ X -> ((forall Y0 Y1 Y2 : Universe, ((rp_ X Y0 /\ (rp_ X Y1 /\ rp_ X Y2)) -> (Y0 = Y1 \/ (Y0 = Y2 \/ Y1 = Y2)))) /\ (exists Y0 Y1 : Universe, (rp_ X Y0 /\ (rp_ X Y1 /\ Y0 <> Y1)))))).

Set Firstorder Depth 10.

Theorem the_axiom_11 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (forall X : Universe, (cc_ X -> ((exists Y0 Y1 : Universe, (rp_ X Y0 /\ (rp_ X Y1 /\ Y0 <> Y1))) /\ (forall Y0 Y1 Y2 : Universe, ((rp_ X Y0 /\ (rp_ X Y1 /\ rp_ X Y2)) -> (Y0 = Y1 \/ (Y0 = Y2 \/ Y1 = Y2))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
