(*
% File     : KRS141+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A simple example
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_allValuesFrom-Manifest001 [Bec03]
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Syntax   : Number of formulae    :    8 (   4 unit)
%            Number of atoms       :   17 (   0 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   13 (   4 ~  ;   0  |;   5  &)
%                                         (   2 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   2 constant; 0-0 arity)
%            Number of variables   :    6 (   0 singleton;   6 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable cr_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.

Variable io_ : Universe.
Variable ii_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cr_ X -> (forall Y : Universe, (rp_ X Y -> cc_ Y)))).
Variable axiom_3_4 : cr_ ii_.
Variable axiom_4_5 : cowlThing_ ii_.
Variable axiom_5_6 : rp_ ii_ io_.
Variable axiom_6_7 : cowlThing_ io_.

Set Firstorder Depth 10.

Theorem the_axiom_8 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (cc_ io_ /\ cowlThing_ io_))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
