(*
% File     : KRS131+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : The complement of a class can be defined
% Version  : Especial.
% English  : The complement of a class can be defined using OWL Lite 
%            restrictions.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : positive_I5.2-Manifest004 [Bec03]
% Status   : Theorem
% Rating   : 0.22 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   20 (   0 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   19 (   6 ~  ;   0  |;   5  &)
%                                         (   5 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   13 (   0 singleton;  10 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rq_ : Universe -> Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cnotA_ : Universe -> Prop.
Variable cNothing_ : Universe -> Prop.
Variable cA_ : Universe -> Prop.


Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cA_ X <-> (exists Y : Universe, (rq_ X Y /\ cowlThing_ Y)))).
Variable axiom_3_4 : (forall X : Universe, (cNothing_ X -> ~((exists Y : Universe, rp_ X Y)))).
Variable axiom_4_5 : (forall X : Universe, (cNothing_ X -> (exists Y0 : Universe, rp_ X Y0))).
Variable axiom_5_6 : (forall X : Universe, (cnotA_ X <-> (forall Y : Universe, (rq_ X Y -> cNothing_ Y)))).

Set Firstorder Depth 10.

Theorem the_axiom_7 : ((forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))) /\ ((forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))) /\ (forall X : Universe, (cnotA_ X <-> ~(cA_ X))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
