(*
% File     : KRS128+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn4.1
% Version  : Especial.
% English  : Tbox tests from [HK+94]
% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest650 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.50 v1.1.0
% Syntax   : Number of formulae    :   12 (   1 unit)
%            Number of atoms       :   29 (   0 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   22 (   5 ~  ;   0  |;   5  &)
%                                         (   9 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   20 (   0 singleton;  13 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests role restrictions
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable ra_Px4_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cexcomp_ : Universe -> Prop.
Variable ce_ : Universe -> Prop.
Variable cdxcomp_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_Cx4xcomp_ : Universe -> Prop.
Variable ca_Cx4_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_22_31584_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ cexcomp_ Y)) /\ ((forall Y : Universe, (rr_ X Y -> cd_ Y)) /\ (forall Y : Universe, (rr_ X Y -> ca_Cx4_ Y)))))).
Variable axiom_3_4 : (forall X : Universe, (cc_ X -> cdxcomp_ X)).
Variable axiom_4_5 : (forall X : Universe, (cd_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_5_6 : (forall X : Universe, (cdxcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_6_7 : (forall X : Universe, (ce_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_7_8 : (forall X : Universe, (cexcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_8_9 : (forall X : Universe, (ca_Cx4_ X <-> (exists Y0 : Universe, ra_Px4_ X Y0))).
Variable axiom_9_10 : (forall X : Universe, (ca_Cx4xcomp_ X <-> ~((exists Y : Universe, ra_Px4_ X Y)))).
Variable axiom_10_11 : (forall X : Universe, (ca_Cx4xcomp_ X <-> (cd_ X /\ cexcomp_ X))).
Variable axiom_11_12 : cUnsatisfiable_ i2003_11_14_17_22_31584_.

Theorem conjecture_13 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
