(*
% File     : KRS127+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn2.2
% Version  : Especial.
% English  : Tbox tests from [HK+94]
% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest646 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   19 (   1 unit)
%            Number of atoms       :   55 (  13 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   39 (   3 ~  ;   0  |;  18  &)
%                                         (   4 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   40 (   0 singleton;  36 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests incoherency caused by number restrictions
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable EqCongruence_ra_Px1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ra_Px1_ x1 x2 -> ra_Px1_ y1 y2 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cdxcomp_ : Universe -> Prop.
Variable EqCongruence_cdxcomp : forall x1 y1 : Universe, x1 = y1 -> cdxcomp_ x1 -> cdxcomp_ y1 .
Variable cd_ : Universe -> Prop.
Variable EqCongruence_cd : forall x1 y1 : Universe, x1 = y1 -> cd_ x1 -> cd_ y1 .
Variable cc_ : Universe -> Prop.
Variable EqCongruence_cc : forall x1 y1 : Universe, x1 = y1 -> cc_ x1 -> cc_ y1 .
Variable cUnsatisfiable_ : Universe -> Prop.
Variable EqCongruence_cUnsatisfiable : forall x1 y1 : Universe, x1 = y1 -> cUnsatisfiable_ x1 -> cUnsatisfiable_ y1 .

Variable i2003_11_14_17_22_27794_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cc_substitution_1_2 : (forall A B : Universe, ((A = B /\ cc_ A) -> cc_ B)).
Variable cd_substitution_1_3 : (forall A B : Universe, ((A = B /\ cd_ A) -> cd_ B)).
Variable cdxcomp_substitution_1_4 : (forall A B : Universe, ((A = B /\ cdxcomp_ A) -> cdxcomp_ B)).
Variable cowlNothing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable ra_Px1_substitution_1_7 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_8 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable rr_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_11 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_13 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_14 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_15 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ cc_ Y)) /\ ((exists Y : Universe, (rr_ X Y /\ cd_ Y)) /\ (forall Y0 Y1 : Universe, ((rr_ X Y0 /\ rr_ X Y1) -> Y0 = Y1)))))).
Variable axiom_3_16 : (forall X : Universe, (cc_ X -> cdxcomp_ X)).
Variable axiom_4_17 : (forall X : Universe, (cd_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_5_18 : (forall X : Universe, (cdxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_6_19 : cUnsatisfiable_ i2003_11_14_17_22_27794_.

Theorem conjecture_20 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
