(*
% File     : KRS124+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn1.2
% Version  : Especial.
% English  : Tbox tests from [HK+94]
% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest642 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.50 v1.1.0
% Syntax   : Number of formulae    :   14 (   1 unit)
%            Number of atoms       :   31 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   21 (   4 ~  ;   0  |;   4  &)
%                                         (   7 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   17 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   19 (   0 singleton;  14 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests incoherency caused by disjoint concept
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cf_ : Universe -> Prop.
Variable ce3_ : Universe -> Prop.
Variable cdxcomp_ : Universe -> Prop.
Variable cd1xcomp_ : Universe -> Prop.
Variable cd1_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc1_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_Ax3_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_22_10903_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ cowlThing_ Y)) /\ (forall Y : Universe, (rr_ X Y -> ca_Ax3_ Y))))).
Variable axiom_3_4 : (forall X : Universe, (cc_ X -> cdxcomp_ X)).
Variable axiom_4_5 : (forall X : Universe, (cc1_ X -> cd1_ X)).
Variable axiom_5_6 : (forall X : Universe, (cc1_ X -> cd1xcomp_ X)).
Variable axiom_6_7 : (forall X : Universe, (cd_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_7_8 : (forall X : Universe, (cdxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_8_9 : (forall X : Universe, (cd1_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_9_10 : (forall X : Universe, (cd1xcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_10_11 : (forall X : Universe, (ce3_ X -> cc_ X)).
Variable axiom_11_12 : (forall X : Universe, (cf_ X -> cd_ X)).
Variable axiom_12_13 : (forall X : Universe, (ca_Ax3_ X <-> (cd_ X /\ cc_ X))).
Variable axiom_13_14 : cUnsatisfiable_ i2003_11_14_17_22_10903_.

Theorem conjecture_15 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
