(*
% File     : KRS116+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t4.1 Dynamic blocking example
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest623 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   18 (   1 unit)
%            Number of atoms       :   54 (   0 equality)
%            Maximal formula depth :   10 (   5 average)
%            Number of connectives :   39 (   3 ~  ;   0  |;  12  &)
%                                         (  13 <=>;  11 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   21 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   37 (   0 singleton;  30 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rs_ : Universe -> Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable rinvS_ : Universe -> Universe -> Prop.
Variable rinvR_ : Universe -> Universe -> Prop.
Variable rinvP_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable caxcomp_ : Universe -> Prop.
Variable ca_Vx7_ : Universe -> Prop.
Variable ca_Vx6_ : Universe -> Prop.
Variable ca_Vx5_ : Universe -> Prop.
Variable ca_Vx4_ : Universe -> Prop.
Variable ca_Vx3_ : Universe -> Prop.
Variable ca_Ax2_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_21_33997_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X -> ca_ X)).
Variable axiom_3_4 : (forall X : Universe, (cUnsatisfiable_ X -> (exists Y : Universe, (rs_ X Y /\ ca_Ax2_ Y)))).
Variable axiom_4_5 : (forall X : Universe, (ca_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_5_6 : (forall X : Universe, (caxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_6_7 : (forall X : Universe, (cc_ X <-> (forall Y : Universe, (rinvR_ X Y -> ca_Vx7_ Y)))).
Variable axiom_7_8 : (forall X : Universe, (ca_Ax2_ X <-> ((forall Y : Universe, (rp_ X Y -> ca_Vx3_ Y)) /\ ((forall Y : Universe, (rp_ X Y -> ca_Vx5_ Y)) /\ ((forall Y : Universe, (rr_ X Y -> cc_ Y)) /\ ((exists Y : Universe, (rr_ X Y /\ cowlThing_ Y)) /\ ((exists Y : Universe, (rp_ X Y /\ cowlThing_ Y)) /\ (forall Y : Universe, (rp_ X Y -> ca_Vx4_ Y))))))))).
Variable axiom_8_9 : (forall X : Universe, (ca_Vx3_ X <-> (exists Y : Universe, (rr_ X Y /\ cowlThing_ Y)))).
Variable axiom_9_10 : (forall X : Universe, (ca_Vx4_ X <-> (exists Y : Universe, (rp_ X Y /\ cowlThing_ Y)))).
Variable axiom_10_11 : (forall X : Universe, (ca_Vx5_ X <-> (forall Y : Universe, (rr_ X Y -> cc_ Y)))).
Variable axiom_11_12 : (forall X : Universe, (ca_Vx6_ X <-> (forall Y : Universe, (rinvS_ X Y -> caxcomp_ Y)))).
Variable axiom_12_13 : (forall X : Universe, (ca_Vx7_ X <-> (forall Y : Universe, (rinvP_ X Y -> ca_Vx6_ Y)))).
Variable axiom_13_14 : (forall X Y : Universe, (rinvP_ X Y <-> rp_ Y X)).
Variable axiom_14_15 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_15_16 : (forall X Y : Universe, (rinvS_ X Y <-> rs_ Y X)).
Variable axiom_16_17 : (forall X Y Z : Universe, ((rp_ X Y /\ rp_ Y Z) -> rp_ X Z)).
Variable axiom_17_18 : cUnsatisfiable_ i2003_11_14_17_21_33997_.

Theorem conjecture_19 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
