(*
% File     : KRS114+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t12.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest615 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   34 (   1 unit)
%            Number of atoms       :   98 (  23 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   68 (   4 ~  ;   0  |;  30  &)
%                                         (  10 <=>;  24 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   18 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   76 (   0 singleton;  69 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rs_ : Universe -> Universe -> Prop.
Variable EqCongruence_rs : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rs_ x1 x2 -> rs_ y1 y2 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable rinvR_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvR : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvR_ x1 x2 -> rinvR_ y1 y2 .
Variable ra_Px2_ : Universe -> Universe -> Prop.
Variable EqCongruence_ra_Px2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ra_Px2_ x1 x2 -> ra_Px2_ y1 y2 .
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable EqCongruence_ra_Px1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ra_Px1_ x1 x2 -> ra_Px1_ y1 y2 .
Variable cqxcomp_ : Universe -> Prop.
Variable EqCongruence_cqxcomp : forall x1 y1 : Universe, x1 = y1 -> cqxcomp_ x1 -> cqxcomp_ y1 .
Variable cq_ : Universe -> Prop.
Variable EqCongruence_cq : forall x1 y1 : Universe, x1 = y1 -> cq_ x1 -> cq_ y1 .
Variable cpxcomp_ : Universe -> Prop.
Variable EqCongruence_cpxcomp : forall x1 y1 : Universe, x1 = y1 -> cpxcomp_ x1 -> cpxcomp_ y1 .
Variable cp_ : Universe -> Prop.
Variable EqCongruence_cp : forall x1 y1 : Universe, x1 = y1 -> cp_ x1 -> cp_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable ca_Vx5_ : Universe -> Prop.
Variable EqCongruence_ca_Vx5 : forall x1 y1 : Universe, x1 = y1 -> ca_Vx5_ x1 -> ca_Vx5_ y1 .
Variable ca_Ax4_ : Universe -> Prop.
Variable EqCongruence_ca_Ax4 : forall x1 y1 : Universe, x1 = y1 -> ca_Ax4_ x1 -> ca_Ax4_ y1 .
Variable ca_Ax3_ : Universe -> Prop.
Variable EqCongruence_ca_Ax3 : forall x1 y1 : Universe, x1 = y1 -> ca_Ax3_ x1 -> ca_Ax3_ y1 .
Variable cUnsatisfiable_ : Universe -> Prop.
Variable EqCongruence_cUnsatisfiable : forall x1 y1 : Universe, x1 = y1 -> cUnsatisfiable_ x1 -> cUnsatisfiable_ y1 .

Variable i2003_11_14_17_21_262_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable ca_Ax3_substitution_1_2 : (forall A B : Universe, ((A = B /\ ca_Ax3_ A) -> ca_Ax3_ B)).
Variable ca_Ax4_substitution_1_3 : (forall A B : Universe, ((A = B /\ ca_Ax4_ A) -> ca_Ax4_ B)).
Variable ca_Vx5_substitution_1_4 : (forall A B : Universe, ((A = B /\ ca_Vx5_ A) -> ca_Vx5_ B)).
Variable cowlNothing_substitution_1_5 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_6 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_7 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable cpxcomp_substitution_1_8 : (forall A B : Universe, ((A = B /\ cpxcomp_ A) -> cpxcomp_ B)).
Variable cq_substitution_1_9 : (forall A B : Universe, ((A = B /\ cq_ A) -> cq_ B)).
Variable cqxcomp_substitution_1_10 : (forall A B : Universe, ((A = B /\ cqxcomp_ A) -> cqxcomp_ B)).
Variable ra_Px1_substitution_1_11 : (forall A B C : Universe, ((A = B /\ ra_Px1_ A C) -> ra_Px1_ B C)).
Variable ra_Px1_substitution_2_12 : (forall A B C : Universe, ((A = B /\ ra_Px1_ C A) -> ra_Px1_ C B)).
Variable ra_Px2_substitution_1_13 : (forall A B C : Universe, ((A = B /\ ra_Px2_ A C) -> ra_Px2_ B C)).
Variable ra_Px2_substitution_2_14 : (forall A B C : Universe, ((A = B /\ ra_Px2_ C A) -> ra_Px2_ C B)).
Variable rinvR_substitution_1_15 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_16 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_17 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_18 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable rs_substitution_1_19 : (forall A B C : Universe, ((A = B /\ rs_ A C) -> rs_ B C)).
Variable rs_substitution_2_20 : (forall A B C : Universe, ((A = B /\ rs_ C A) -> rs_ C B)).
Variable xsd_integer_substitution_1_21 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_22 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_23 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_24 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_25 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rr_ X Y /\ ca_Ax4_ Y)) /\ (exists Y : Universe, (rs_ X Y /\ ca_Ax3_ Y))))).
Variable axiom_3_26 : (forall X : Universe, (cp_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_4_27 : (forall X : Universe, (cpxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_5_28 : (forall X : Universe, (cq_ X <-> (exists Y0 : Universe, ra_Px2_ X Y0))).
Variable axiom_6_29 : (forall X : Universe, (cqxcomp_ X <-> ~((exists Y : Universe, ra_Px2_ X Y)))).
Variable axiom_7_30 : (forall X : Universe, (ca_Ax3_ X <-> (cqxcomp_ X /\ cpxcomp_ X))).
Variable axiom_8_31 : (forall X : Universe, (ca_Ax4_ X <-> ((forall Y0 Y1 : Universe, ((rinvR_ X Y0 /\ rinvR_ X Y1) -> Y0 = Y1)) /\ (exists Y : Universe, (rinvR_ X Y /\ ca_Vx5_ Y))))).
Variable axiom_9_32 : (forall X : Universe, (ca_Vx5_ X <-> (forall Y : Universe, (rs_ X Y -> cp_ Y)))).
Variable axiom_10_33 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_11_34 : cUnsatisfiable_ i2003_11_14_17_21_262_.

Theorem conjecture_35 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
