(*
% File     : KRS105+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: fact2.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest602 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.50 v1.1.0
% Syntax   : Number of formulae    :   10 (   1 unit)
%            Number of atoms       :   21 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :   14 (   3 ~  ;   0  |;   1  &)
%                                         (   4 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   13 (   0 singleton;  11 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rr_ : Universe -> Universe -> Prop.
Variable ra_Px1_ : Universe -> Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cdxcomp_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable ca_Ax2_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_20_53634_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X -> cdxcomp_ X)).
Variable axiom_3_4 : (forall X : Universe, (cUnsatisfiable_ X -> cc_ X)).
Variable axiom_4_5 : (forall X : Universe, (cc_ X -> (forall Y : Universe, (rr_ X Y -> cc_ Y)))).
Variable axiom_5_6 : (forall X : Universe, (cd_ X <-> ~((exists Y : Universe, ra_Px1_ X Y)))).
Variable axiom_6_7 : (forall X : Universe, (cdxcomp_ X <-> (exists Y0 : Universe, ra_Px1_ X Y0))).
Variable axiom_7_8 : (forall X : Universe, (ca_Ax2_ X <-> (forall Y : Universe, (rr_ X Y -> cc_ Y)))).
Variable axiom_8_9 : (forall X : Universe, (ca_Ax2_ X -> cd_ X)).
Variable axiom_9_10 : cUnsatisfiable_ i2003_11_14_17_20_53634_.

Theorem conjecture_11 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
