(*
% File     : KRS103+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : A different encoding of description-logic-502
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest504 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   57 (   1 unit)
%            Number of atoms       :  203 (   0 equality)
%            Maximal formula depth :    5 (   5 average)
%            Number of connectives :  157 (  11 ~  ;  90  |;  10  &)
%                                         (   1 <=>;  45 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   23 (   0 propositional; 1-1 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   56 (   0 singleton;  56 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cplus9_ : Universe -> Prop.
Variable cplus8_ : Universe -> Prop.
Variable cplus7_ : Universe -> Prop.
Variable cplus6_ : Universe -> Prop.
Variable cplus5_ : Universe -> Prop.
Variable cplus4_ : Universe -> Prop.
Variable cplus3_ : Universe -> Prop.
Variable cplus2_ : Universe -> Prop.
Variable cplus1_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cminus9_ : Universe -> Prop.
Variable cminus8_ : Universe -> Prop.
Variable cminus7_ : Universe -> Prop.
Variable cminus6_ : Universe -> Prop.
Variable cminus5_ : Universe -> Prop.
Variable cminus4_ : Universe -> Prop.
Variable cminus3_ : Universe -> Prop.
Variable cminus2_ : Universe -> Prop.
Variable cminus1_ : Universe -> Prop.
Variable cTest_ : Universe -> Prop.

Variable i2003_11_14_17_20_46476_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cTest_ X -> (cplus1_ X \/ (cplus9_ X \/ cminus6_ X)))).
Variable axiom_3_4 : (forall X : Universe, (cTest_ X -> (cminus3_ X \/ (cminus5_ X \/ cminus8_ X)))).
Variable axiom_4_5 : (forall X : Universe, (cTest_ X -> (cminus3_ X \/ (cplus7_ X \/ cplus8_ X)))).
Variable axiom_5_6 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus6_ X \/ cplus8_ X)))).
Variable axiom_6_7 : (forall X : Universe, (cTest_ X -> (cplus3_ X \/ (cminus7_ X \/ cplus8_ X)))).
Variable axiom_7_8 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus5_ X \/ cplus9_ X)))).
Variable axiom_8_9 : (forall X : Universe, (cTest_ X -> (cminus7_ X \/ (cplus9_ X \/ cminus6_ X)))).
Variable axiom_9_10 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cminus4_ X \/ cminus8_ X)))).
Variable axiom_10_11 : (forall X : Universe, (cTest_ X -> (cplus3_ X \/ (cminus4_ X \/ cplus6_ X)))).
Variable axiom_11_12 : (forall X : Universe, (cTest_ X -> (cplus4_ X \/ (cplus6_ X \/ cminus8_ X)))).
Variable axiom_12_13 : (forall X : Universe, (cTest_ X -> (cminus1_ X \/ (cminus4_ X \/ cplus6_ X)))).
Variable axiom_13_14 : (forall X : Universe, (cTest_ X -> (cplus2_ X \/ (cplus5_ X \/ cplus9_ X)))).
Variable axiom_14_15 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus2_ X \/ cplus1_ X)))).
Variable axiom_15_16 : (forall X : Universe, (cTest_ X -> (cminus3_ X \/ (cplus5_ X \/ cminus8_ X)))).
Variable axiom_16_17 : (forall X : Universe, (cTest_ X -> (cplus6_ X \/ (cminus8_ X \/ cminus7_ X)))).
Variable axiom_17_18 : (forall X : Universe, (cTest_ X -> (cplus3_ X \/ (cplus4_ X \/ cplus1_ X)))).
Variable axiom_18_19 : (forall X : Universe, (cTest_ X -> (cminus2_ X \/ (cplus6_ X \/ cplus9_ X)))).
Variable axiom_19_20 : (forall X : Universe, (cTest_ X -> (cplus2_ X \/ (cplus1_ X \/ cminus6_ X)))).
Variable axiom_20_21 : (forall X : Universe, (cTest_ X -> (cminus3_ X \/ (cplus2_ X \/ cplus8_ X)))).
Variable axiom_21_22 : (forall X : Universe, (cTest_ X -> (cminus2_ X \/ (cplus4_ X \/ cminus6_ X)))).
Variable axiom_22_23 : (forall X : Universe, (cTest_ X -> (cminus2_ X \/ (cplus6_ X \/ cminus7_ X)))).
Variable axiom_23_24 : (forall X : Universe, (cTest_ X -> (cplus5_ X \/ (cminus7_ X \/ cplus9_ X)))).
Variable axiom_24_25 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cminus2_ X \/ cminus5_ X)))).
Variable axiom_25_26 : (forall X : Universe, (cTest_ X -> (cplus3_ X \/ (cplus4_ X \/ cplus9_ X)))).
Variable axiom_26_27 : (forall X : Universe, (cTest_ X -> (cplus2_ X \/ (cminus5_ X \/ cminus7_ X)))).
Variable axiom_27_28 : (forall X : Universe, (cTest_ X -> (cplus4_ X \/ (cminus5_ X \/ cplus6_ X)))).
Variable axiom_28_29 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cplus3_ X \/ cplus4_ X)))).
Variable axiom_29_30 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cminus3_ X \/ cminus7_ X)))).
Variable axiom_30_31 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus1_ X \/ cplus9_ X)))).
Variable axiom_31_32 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cminus8_ X \/ cplus9_ X)))).
Variable axiom_32_33 : (forall X : Universe, (cTest_ X -> (cplus3_ X \/ (cminus8_ X \/ cplus9_ X)))).
Variable axiom_33_34 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cminus2_ X \/ cplus7_ X)))).
Variable axiom_34_35 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus9_ X \/ cplus7_ X)))).
Variable axiom_35_36 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cminus2_ X \/ cplus3_ X)))).
Variable axiom_36_37 : (forall X : Universe, (cTest_ X -> (cminus1_ X \/ (cplus4_ X \/ cplus2_ X)))).
Variable axiom_37_38 : (forall X : Universe, (cTest_ X -> (cminus2_ X \/ (cminus3_ X \/ cplus1_ X)))).
Variable axiom_38_39 : (forall X : Universe, (cTest_ X -> (cplus3_ X \/ (cplus4_ X \/ cplus6_ X)))).
Variable axiom_39_40 : (forall X : Universe, (cTest_ X -> (cminus2_ X \/ (cplus3_ X \/ cminus8_ X)))).
Variable axiom_40_41 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cplus3_ X \/ cminus5_ X)))).
Variable axiom_41_42 : (forall X : Universe, (cTest_ X -> (cplus4_ X \/ (cplus1_ X \/ cplus7_ X)))).
Variable axiom_42_43 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cminus3_ X \/ cplus6_ X)))).
Variable axiom_43_44 : (forall X : Universe, (cTest_ X -> (cminus9_ X \/ (cplus1_ X \/ cminus6_ X)))).
Variable axiom_44_45 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus1_ X \/ cminus6_ X)))).
Variable axiom_45_46 : (forall X : Universe, (cTest_ X -> (cminus4_ X \/ (cplus2_ X \/ cplus8_ X)))).
Variable axiom_46_47 : (forall X : Universe, (cTest_ X -> (cminus5_ X \/ (cplus7_ X \/ cplus8_ X)))).
Variable axiom_47_48 : cTest_ i2003_11_14_17_20_46476_.
Variable axiom_48_49 : (forall X : Universe, ~((cminus8_ X /\ cplus8_ X))).
Variable axiom_49_50 : (forall X : Universe, ~((cminus9_ X /\ cplus9_ X))).
Variable axiom_50_51 : (forall X : Universe, ~((cplus4_ X /\ cminus4_ X))).
Variable axiom_51_52 : (forall X : Universe, ~((cminus7_ X /\ cplus7_ X))).
Variable axiom_52_53 : (forall X : Universe, ~((cplus3_ X /\ cminus3_ X))).
Variable axiom_53_54 : (forall X : Universe, ~((cplus5_ X /\ cminus5_ X))).
Variable axiom_54_55 : (forall X : Universe, ~((cminus2_ X /\ cplus2_ X))).
Variable axiom_55_56 : (forall X : Universe, ~((cminus1_ X /\ cplus1_ X))).
Variable axiom_56_57 : (forall X : Universe, ~((cplus6_ X /\ cminus6_ X))).

Theorem conjecture_58 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
