(*
% File     : KRS094+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: heinsohn1.4
% Version  : Especial.
% English  : Tbox tests from [HK+94]
% Refs     : [HK+94] Heinsohn et al. (1994), An Empirical Analysis of Termi
%          : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest104 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.25 v1.1.0
% Syntax   : Number of formulae    :    9 (   1 unit)
%            Number of atoms       :   17 (   0 equality)
%            Maximal formula depth :    4 (   3 average)
%            Number of connectives :   12 (   4 ~  ;   0  |;   1  &)
%                                         (   2 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-1 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :    8 (   0 singleton;   8 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
%          : Tests incoherency caused by disjoint concept
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable cf_ : Universe -> Prop.
Variable ce3_ : Universe -> Prop.
Variable cd1_ : Universe -> Prop.
Variable cd_ : Universe -> Prop.
Variable cc1_ : Universe -> Prop.
Variable cc_ : Universe -> Prop.
Variable cUnsatisfiable_ : Universe -> Prop.

Variable i2003_11_14_17_20_11330_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_3 : (forall X : Universe, (cUnsatisfiable_ X <-> cc1_ X)).
Variable axiom_3_4 : (forall X : Universe, (cc_ X -> ~(cd_ X))).
Variable axiom_4_5 : (forall X : Universe, (cc1_ X -> ~(cd1_ X))).
Variable axiom_5_6 : (forall X : Universe, (cc1_ X -> cd1_ X)).
Variable axiom_6_7 : (forall X : Universe, (ce3_ X -> cc_ X)).
Variable axiom_7_8 : (forall X : Universe, (cf_ X -> cd_ X)).
Variable axiom_8_9 : cUnsatisfiable_ i2003_11_14_17_20_11330_.

Theorem conjecture_10 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
