(*
% File     : KRS088+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t7f.3
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest033 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   22 (   1 unit)
%            Number of atoms       :   63 (  15 equality)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   44 (   3 ~  ;   0  |;  20  &)
%                                         (   4 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   52 (   0 singleton;  50 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable rinvR_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvR : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvR_ x1 x2 -> rinvR_ y1 y2 .
Variable rinvF_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvF : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvF_ x1 x2 -> rinvF_ y1 y2 .
Variable rf_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf_ x1 x2 -> rf_ y1 y2 .
Variable cp1_ : Universe -> Prop.
Variable EqCongruence_cp1 : forall x1 y1 : Universe, x1 = y1 -> cp1_ x1 -> cp1_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cUnsatisfiable_ : Universe -> Prop.
Variable EqCongruence_cUnsatisfiable : forall x1 y1 : Universe, x1 = y1 -> cUnsatisfiable_ x1 -> cUnsatisfiable_ y1 .

Variable i2003_11_14_17_19_49673_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable rf_substitution_1_5 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_6 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rinvF_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvR_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_14 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_15 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_16 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_17 : (forall X : Universe, (cUnsatisfiable_ X <-> (exists Y : Universe, (rf_ X Y /\ ((forall Z : Universe, (rinvF_ Y Z -> (exists W : Universe, (rf_ Z W /\ ~(cp1_ W))))) /\ cp1_ Y))))).
Variable axiom_3_18 : (forall X Y Z : Universe, ((rf_ X Y /\ rf_ X Z) -> Y = Z)).
Variable axiom_4_19 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_5_20 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_6_21 : (forall X Y Z : Universe, ((rr_ X Y /\ rr_ Y Z) -> rr_ X Z)).
Variable axiom_7_22 : cUnsatisfiable_ i2003_11_14_17_19_49673_.

Theorem conjecture_23 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
