(*
% File     : KRS076+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t10.5
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest013 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   30 (   1 unit)
%            Number of atoms       :   86 (  21 equality)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   59 (   3 ~  ;   0  |;  27  &)
%                                         (   5 <=>;  24 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   74 (   0 singleton;  71 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rs_ : Universe -> Universe -> Prop.
Variable EqCongruence_rs : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rs_ x1 x2 -> rs_ y1 y2 .
Variable rinvS_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvS : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvS_ x1 x2 -> rinvS_ y1 y2 .
Variable rinvF1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvF1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvF1_ x1 x2 -> rinvF1_ y1 y2 .
Variable rinvF_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvF : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvF_ x1 x2 -> rinvF_ y1 y2 .
Variable rf1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf1_ x1 x2 -> rf1_ y1 y2 .
Variable rf_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf_ x1 x2 -> rf_ y1 y2 .
Variable cp_ : Universe -> Prop.
Variable EqCongruence_cp : forall x1 y1 : Universe, x1 = y1 -> cp_ x1 -> cp_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cUnsatisfiable_ : Universe -> Prop.
Variable EqCongruence_cUnsatisfiable : forall x1 y1 : Universe, x1 = y1 -> cUnsatisfiable_ x1 -> cUnsatisfiable_ y1 .

Variable i2003_11_14_17_19_06193_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp_ A) -> cp_ B)).
Variable rf_substitution_1_5 : (forall A B C : Universe, ((A = B /\ rf_ A C) -> rf_ B C)).
Variable rf_substitution_2_6 : (forall A B C : Universe, ((A = B /\ rf_ C A) -> rf_ C B)).
Variable rf1_substitution_1_7 : (forall A B C : Universe, ((A = B /\ rf1_ A C) -> rf1_ B C)).
Variable rf1_substitution_2_8 : (forall A B C : Universe, ((A = B /\ rf1_ C A) -> rf1_ C B)).
Variable rinvF_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rinvF_ A C) -> rinvF_ B C)).
Variable rinvF_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rinvF_ C A) -> rinvF_ C B)).
Variable rinvF1_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rinvF1_ A C) -> rinvF1_ B C)).
Variable rinvF1_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rinvF1_ C A) -> rinvF1_ C B)).
Variable rinvS_substitution_1_13 : (forall A B C : Universe, ((A = B /\ rinvS_ A C) -> rinvS_ B C)).
Variable rinvS_substitution_2_14 : (forall A B C : Universe, ((A = B /\ rinvS_ C A) -> rinvS_ C B)).
Variable rs_substitution_1_15 : (forall A B C : Universe, ((A = B /\ rs_ A C) -> rs_ B C)).
Variable rs_substitution_2_16 : (forall A B C : Universe, ((A = B /\ rs_ C A) -> rs_ C B)).
Variable xsd_integer_substitution_1_17 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_18 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_19 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_20 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_21 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rf_ X Y /\ cp_ Y)) /\ (exists Y : Universe, (rf1_ X Y /\ (~(cp_ Y) /\ (forall Z : Universe, (rinvF1_ Y Z -> (exists W : Universe, (rs_ Z W /\ cowlThing_ W)))))))))).
Variable axiom_3_22 : (forall X Y Z : Universe, ((rf_ X Y /\ rf_ X Z) -> Y = Z)).
Variable axiom_4_23 : (forall X Y Z : Universe, ((rf1_ X Y /\ rf1_ X Z) -> Y = Z)).
Variable axiom_5_24 : (forall X Y : Universe, (rinvF_ X Y <-> rf_ Y X)).
Variable axiom_6_25 : (forall X Y : Universe, (rinvF1_ X Y <-> rf1_ Y X)).
Variable axiom_7_26 : (forall X Y : Universe, (rinvS_ X Y <-> rs_ Y X)).
Variable axiom_8_27 : (forall X Y Z : Universe, ((rs_ X Y /\ rs_ X Z) -> Y = Z)).
Variable axiom_9_28 : cUnsatisfiable_ i2003_11_14_17_19_06193_.
Variable axiom_10_29 : (forall X Y : Universe, (rs_ X Y -> rf1_ X Y)).
Variable axiom_11_30 : (forall X Y : Universe, (rs_ X Y -> rf_ X Y)).

Theorem conjecture_31 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
