(*
% File     : KRS072+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: t1.3
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest008 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem (Problem negated)
% Rating (intuit.) : 0.75 v1.1.0
% Syntax   : Number of formulae    :   23 (   1 unit)
%            Number of atoms       :   71 (  15 equality)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   54 (   6 ~  ;   6  |;  20  &)
%                                         (   3 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   45 (   0 singleton;  43 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rr_ : Universe -> Universe -> Prop.
Variable EqCongruence_rr : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rr_ x1 x2 -> rr_ y1 y2 .
Variable rinvR_ : Universe -> Universe -> Prop.
Variable EqCongruence_rinvR : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rinvR_ x1 x2 -> rinvR_ y1 y2 .
Variable cp5_ : Universe -> Prop.
Variable EqCongruence_cp5 : forall x1 y1 : Universe, x1 = y1 -> cp5_ x1 -> cp5_ y1 .
Variable cp4_ : Universe -> Prop.
Variable EqCongruence_cp4 : forall x1 y1 : Universe, x1 = y1 -> cp4_ x1 -> cp4_ y1 .
Variable cp3_ : Universe -> Prop.
Variable EqCongruence_cp3 : forall x1 y1 : Universe, x1 = y1 -> cp3_ x1 -> cp3_ y1 .
Variable cp2_ : Universe -> Prop.
Variable EqCongruence_cp2 : forall x1 y1 : Universe, x1 = y1 -> cp2_ x1 -> cp2_ y1 .
Variable cp1_ : Universe -> Prop.
Variable EqCongruence_cp1 : forall x1 y1 : Universe, x1 = y1 -> cp1_ x1 -> cp1_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cUnsatisfiable_ : Universe -> Prop.
Variable EqCongruence_cUnsatisfiable : forall x1 y1 : Universe, x1 = y1 -> cUnsatisfiable_ x1 -> cUnsatisfiable_ y1 .

Variable i2003_11_14_17_18_50190_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp2_substitution_1_5 : (forall A B : Universe, ((A = B /\ cp2_ A) -> cp2_ B)).
Variable cp3_substitution_1_6 : (forall A B : Universe, ((A = B /\ cp3_ A) -> cp3_ B)).
Variable cp4_substitution_1_7 : (forall A B : Universe, ((A = B /\ cp4_ A) -> cp4_ B)).
Variable cp5_substitution_1_8 : (forall A B : Universe, ((A = B /\ cp5_ A) -> cp5_ B)).
Variable rinvR_substitution_1_9 : (forall A B C : Universe, ((A = B /\ rinvR_ A C) -> rinvR_ B C)).
Variable rinvR_substitution_2_10 : (forall A B C : Universe, ((A = B /\ rinvR_ C A) -> rinvR_ C B)).
Variable rr_substitution_1_11 : (forall A B C : Universe, ((A = B /\ rr_ A C) -> rr_ B C)).
Variable rr_substitution_2_12 : (forall A B C : Universe, ((A = B /\ rr_ C A) -> rr_ C B)).
Variable xsd_integer_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_14 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_15 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_16 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_17 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rinvR_ X Y /\ ((forall Z0 Z1 : Universe, ((rr_ Y Z0 /\ rr_ Y Z1) -> Z0 = Z1)) /\ (exists Z : Universe, (rr_ Y Z /\ cp1_ Z))))) /\ cp2_ X))).
Variable axiom_3_18 : (forall X : Universe, (cp1_ X -> ~((cp3_ X \/ (cp2_ X \/ (cp4_ X \/ cp5_ X)))))).
Variable axiom_4_19 : (forall X : Universe, (cp2_ X -> ~((cp3_ X \/ (cp4_ X \/ cp5_ X))))).
Variable axiom_5_20 : (forall X : Universe, (cp3_ X -> ~((cp4_ X \/ cp5_ X)))).
Variable axiom_6_21 : (forall X : Universe, (cp4_ X -> ~(cp5_ X))).
Variable axiom_7_22 : (forall X Y : Universe, (rinvR_ X Y <-> rr_ Y X)).
Variable axiom_8_23 : cUnsatisfiable_ i2003_11_14_17_18_50190_.

Theorem conjecture_24 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
