(*
% File     : KRS069+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : DL Test: fact3.1
% Version  : Especial.
% English  : 
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : inconsistent_description-logic-Manifest003 [Bec03]
% Status   : Unsatisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Open (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   22 (   1 unit)
%            Number of atoms       :   64 (  16 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   45 (   3 ~  ;   0  |;  22  &)
%                                         (   2 <=>;  18 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   51 (   0 singleton;  48 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable xsd_string_ : Universe -> Prop.
Variable EqCongruence_xsd_string : forall x1 y1 : Universe, x1 = y1 -> xsd_string_ x1 -> xsd_string_ y1 .
Variable xsd_integer_ : Universe -> Prop.
Variable EqCongruence_xsd_integer : forall x1 y1 : Universe, x1 = y1 -> xsd_integer_ x1 -> xsd_integer_ y1 .
Variable rf3_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf3 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf3_ x1 x2 -> rf3_ y1 y2 .
Variable rf2_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf2_ x1 x2 -> rf2_ y1 y2 .
Variable rf1_ : Universe -> Universe -> Prop.
Variable EqCongruence_rf1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rf1_ x1 x2 -> rf1_ y1 y2 .
Variable cp2_ : Universe -> Prop.
Variable EqCongruence_cp2 : forall x1 y1 : Universe, x1 = y1 -> cp2_ x1 -> cp2_ y1 .
Variable cp1_ : Universe -> Prop.
Variable EqCongruence_cp1 : forall x1 y1 : Universe, x1 = y1 -> cp1_ x1 -> cp1_ y1 .
Variable cowlThing_ : Universe -> Prop.
Variable EqCongruence_cowlThing : forall x1 y1 : Universe, x1 = y1 -> cowlThing_ x1 -> cowlThing_ y1 .
Variable cowlNothing_ : Universe -> Prop.
Variable EqCongruence_cowlNothing : forall x1 y1 : Universe, x1 = y1 -> cowlNothing_ x1 -> cowlNothing_ y1 .
Variable cUnsatisfiable_ : Universe -> Prop.
Variable EqCongruence_cUnsatisfiable : forall x1 y1 : Universe, x1 = y1 -> cUnsatisfiable_ x1 -> cUnsatisfiable_ y1 .

Variable i2003_11_14_17_18_2750_ : Universe.

Variable cUnsatisfiable_substitution_1_1 : (forall A B : Universe, ((A = B /\ cUnsatisfiable_ A) -> cUnsatisfiable_ B)).
Variable cowlNothing_substitution_1_2 : (forall A B : Universe, ((A = B /\ cowlNothing_ A) -> cowlNothing_ B)).
Variable cowlThing_substitution_1_3 : (forall A B : Universe, ((A = B /\ cowlThing_ A) -> cowlThing_ B)).
Variable cp1_substitution_1_4 : (forall A B : Universe, ((A = B /\ cp1_ A) -> cp1_ B)).
Variable cp2_substitution_1_5 : (forall A B : Universe, ((A = B /\ cp2_ A) -> cp2_ B)).
Variable rf1_substitution_1_6 : (forall A B C : Universe, ((A = B /\ rf1_ A C) -> rf1_ B C)).
Variable rf1_substitution_2_7 : (forall A B C : Universe, ((A = B /\ rf1_ C A) -> rf1_ C B)).
Variable rf2_substitution_1_8 : (forall A B C : Universe, ((A = B /\ rf2_ A C) -> rf2_ B C)).
Variable rf2_substitution_2_9 : (forall A B C : Universe, ((A = B /\ rf2_ C A) -> rf2_ C B)).
Variable rf3_substitution_1_10 : (forall A B C : Universe, ((A = B /\ rf3_ A C) -> rf3_ B C)).
Variable rf3_substitution_2_11 : (forall A B C : Universe, ((A = B /\ rf3_ C A) -> rf3_ C B)).
Variable xsd_integer_substitution_1_12 : (forall A B : Universe, ((A = B /\ xsd_integer_ A) -> xsd_integer_ B)).
Variable xsd_string_substitution_1_13 : (forall A B : Universe, ((A = B /\ xsd_string_ A) -> xsd_string_ B)).
Variable axiom_0_14 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_15 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_16 : (forall X : Universe, (cUnsatisfiable_ X <-> ((exists Y : Universe, (rf1_ X Y /\ cp1_ Y)) /\ ((exists Y : Universe, (rf2_ X Y /\ ~(cp1_ Y))) /\ (exists Y : Universe, (rf3_ X Y /\ cp2_ Y)))))).
Variable axiom_3_17 : (forall X Y Z : Universe, ((rf1_ X Y /\ rf1_ X Z) -> Y = Z)).
Variable axiom_4_18 : (forall X Y Z : Universe, ((rf2_ X Y /\ rf2_ X Z) -> Y = Z)).
Variable axiom_5_19 : (forall X Y Z : Universe, ((rf3_ X Y /\ rf3_ X Z) -> Y = Z)).
Variable axiom_6_20 : cUnsatisfiable_ i2003_11_14_17_18_2750_.
Variable axiom_7_21 : (forall X Y : Universe, (rf3_ X Y -> rf1_ X Y)).
Variable axiom_8_22 : (forall X Y : Universe, (rf3_ X Y -> rf2_ X Y)).

Theorem conjecture_23 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
