(*
% File     : KRS059+1 : ILTP v1.1.2
% Domain   : Knowledge Representation (Semantic Web)
% Problem  : Abstract syntax restrictions with multiple components
% Version  : Especial.
% English  : Abstract syntax restrictions with multiple components are in OWL 
%            DL.
% Refs     : [Bec03] Bechhofer (2003), Email to G. Sutcliffe
%          : [TR+04] Tsarkov et al. (2004), Using Vampire to Reason with OW
% Source   : [Bec03]
% Names    : consistent_miscellaneous-Manifest102 [Bec03]
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    5 (   1 unit)
%            Number of atoms       :    9 (   0 equality)
%            Maximal formula depth :    4 (   3 average)
%            Number of connectives :    6 (   2 ~  ;   0  |;   2  &)
%                                         (   1 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :    4 (   0 singleton;   3 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Sean Bechhofer says there are some errors in the encoding of
%            datatypes, so this problem may not be perfect. At least it's
%            still representative of the type of reasoning required for OWL.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable xsd_string_ : Universe -> Prop.
Variable xsd_integer_ : Universe -> Prop.
Variable rp_ : Universe -> Universe -> Prop.
Variable cs_ : Universe -> Prop.
Variable cowlThing_ : Universe -> Prop.
Variable cowlNothing_ : Universe -> Prop.
Variable ca_ : Universe -> Prop.

Variable ii_ : Universe.

Variable axiom_0_1 : (forall X : Universe, (cowlThing_ X /\ ~(cowlNothing_ X))).
Variable axiom_1_2 : (forall X : Universe, (xsd_string_ X <-> ~(xsd_integer_ X))).
Variable axiom_2_AndLHS_3 : (exists X : Universe, (rp_ ii_ X /\ cs_ X)).
Variable axiom_2_AndRHS_4 : (forall X : Universe, (rp_ ii_ X -> ca_ X)).
Variable axiom_3_5 : cowlThing_ ii_.

Theorem conjecture_6 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
